/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class TypeToken<T> {
    private final Class<? super T> rawType;
    private final Type type;

    protected TypeToken() {
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("TypeToken is missing a type-parameter");
        }
        ParameterizedType superclass = (ParameterizedType)type;
        this.type = superclass.getActualTypeArguments()[0];
        this.rawType = TypeToken.findRawType(this.type);
    }

    private TypeToken(Type type) {
        this(type, TypeToken.findRawType(type));
    }

    private TypeToken(Type type, Class<? super T> rawType) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(type, "rawType is null");
        this.type = type;
        this.rawType = rawType;
    }

    public boolean is(Class<?> supertype) {
        return supertype.isAssignableFrom(this.rawType);
    }

    public boolean isArray() {
        Class clazz;
        Type type;
        return this.type instanceof GenericArrayType || (type = this.type) instanceof Class && (clazz = (Class)type).isArray();
    }

    public Type getComponentType() {
        Type type;
        Type type2 = this.type;
        if (type2 instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type2;
            type = array.getGenericComponentType();
        } else {
            type = this.rawType.getComponentType();
        }
        return type;
    }

    public Type getSupertype(Class<?> supertype) {
        return TypeToken.resolve(this.type, this.rawType, TypeToken.findSupertype(this.type, this.rawType, supertype));
    }

    public Type resolve(Type type) {
        return TypeToken.resolve(this.type, this.rawType, type);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeToken)) {
            return false;
        }
        TypeToken typeToken = (TypeToken)o;
        return this.type.equals(typeToken.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return TypeToken.typeToString(this.type);
    }

    public static TypeToken<?> of(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        return new TypeToken<T>(type);
    }

    public static TypeToken<?> of(Type rawType, Type ... typeArguments) {
        return new TypeToken(new ParameterizedTypeImpl(null, rawType, typeArguments));
    }

    public static TypeToken<?> array(Type componentType) {
        return new TypeToken(new GenericArrayTypeImpl(componentType));
    }

    private static Class<?> findRawType(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Class.class, ParameterizedType.class, GenericArrayType.class, WildcardType.class}, (Object)type3, n)) {
            case 0 -> {
                Class<?> clazz;
                yield clazz = (Class<?>)type3;
            }
            case 1 -> {
                ParameterizedType pType = (ParameterizedType)type3;
                yield (Class)pType.getRawType();
            }
            case 2 -> {
                GenericArrayType array = (GenericArrayType)type3;
                yield Array.newInstance(TypeToken.findRawType(array.getGenericComponentType()), 0).getClass();
            }
            case 3 -> {
                WildcardType wildcard = (WildcardType)type3;
                yield TypeToken.findRawType(wildcard.getUpperBounds()[0]);
            }
            default -> Object.class;
        };
    }

    private static Type findSupertype(Type type, Class<?> rawType, Class<?> supertype) {
        Class<?> parent;
        if (supertype == rawType) {
            return type;
        }
        if (supertype.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!supertype.isAssignableFrom(interfaces[i])) continue;
                return TypeToken.of(rawType.getGenericInterfaces()[i]).getSupertype(supertype);
            }
        }
        if ((parent = rawType.getSuperclass()) != null && parent != Object.class && supertype.isAssignableFrom(parent)) {
            return TypeToken.of(rawType.getGenericSuperclass()).getSupertype(supertype);
        }
        return supertype;
    }

    private static Type resolve(Type context, Class<?> rawContext, @Nullable Type type) {
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeVariable.class, Class.class, GenericArrayType.class, ParameterizedType.class, WildcardType.class}, (Object)type2, n)) {
            case 0 -> {
                TypeVariable typeVariable = (TypeVariable)type2;
                Object genericDeclaration = typeVariable.getGenericDeclaration();
                if (!(genericDeclaration instanceof Class)) {
                    yield typeVariable;
                }
                Class declaringRawType = (Class)genericDeclaration;
                Type declaringType = TypeToken.findSupertype(context, rawContext, declaringRawType);
                if (declaringType instanceof ParameterizedType) {
                    ParameterizedType declaringParameterized = (ParameterizedType)declaringType;
                    int typeParameterIndex = TypeToken.indexOf(declaringRawType.getTypeParameters(), typeVariable);
                    yield TypeToken.resolve(context, rawContext, declaringParameterized.getActualTypeArguments()[typeParameterIndex]);
                }
                yield typeVariable;
            }
            case 1 -> {
                Type resolvedComponentType;
                Class classType = (Class)type2;
                if (!classType.isArray()) {
                    yield classType;
                }
                Class<?> componentType = classType.getComponentType();
                if (componentType != (resolvedComponentType = TypeToken.resolve(context, rawContext, componentType))) {
                    yield new GenericArrayTypeImpl(resolvedComponentType);
                }
                yield classType;
            }
            case 2 -> {
                GenericArrayType genericArrayType = (GenericArrayType)type2;
                Type componentType = genericArrayType.getGenericComponentType();
                Type resolvedComponentType = TypeToken.resolve(context, rawContext, componentType);
                if (componentType != resolvedComponentType) {
                    yield new GenericArrayTypeImpl(resolvedComponentType);
                }
                yield genericArrayType;
            }
            case 3 -> {
                Type[] typeArguments;
                ParameterizedType parameterizedType = (ParameterizedType)type2;
                Type ownerType = parameterizedType.getOwnerType();
                Type resolvedOwnerType = TypeToken.resolve(context, rawContext, ownerType);
                Type[] resolvedTypeArguments = typeArguments = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type resolvedTypeArgument = TypeToken.resolve(context, rawContext, typeArguments[i]);
                    if (typeArguments[i] != resolvedTypeArgument && typeArguments == resolvedTypeArguments) {
                        resolvedTypeArguments = Arrays.copyOf(typeArguments, typeArguments.length);
                    }
                    resolvedTypeArguments[i] = resolvedTypeArgument;
                }
                if (ownerType != resolvedOwnerType || typeArguments != resolvedTypeArguments) {
                    yield new ParameterizedTypeImpl(resolvedOwnerType, parameterizedType.getRawType(), resolvedTypeArguments);
                }
                yield parameterizedType;
            }
            case 4 -> {
                int i;
                WildcardType wildcardType = (WildcardType)type2;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                Type[] upperBounds = wildcardType.getUpperBounds();
                Type[] resolvedLowerBounds = lowerBounds;
                Type[] resolvedUpperBounds = upperBounds;
                for (i = 0; i < lowerBounds.length; ++i) {
                    Type resolvedLowerBound = TypeToken.resolve(context, rawContext, lowerBounds[i]);
                    if (lowerBounds[i] != resolvedLowerBound && lowerBounds == resolvedLowerBounds) {
                        resolvedLowerBounds = Arrays.copyOf(lowerBounds, lowerBounds.length);
                    }
                    resolvedLowerBounds[i] = resolvedLowerBound;
                }
                for (i = 0; i < upperBounds.length; ++i) {
                    Type resolvedUpperBound = TypeToken.resolve(context, rawContext, upperBounds[i]);
                    if (upperBounds[i] != resolvedUpperBound && upperBounds == resolvedUpperBounds) {
                        resolvedUpperBounds = Arrays.copyOf(upperBounds, upperBounds.length);
                    }
                    resolvedUpperBounds[i] = resolvedUpperBound;
                }
                if (lowerBounds != resolvedLowerBounds || upperBounds != resolvedUpperBounds) {
                    yield new WildcardTypeImpl(resolvedUpperBounds, resolvedLowerBounds);
                }
                yield wildcardType;
            }
            default -> type;
        };
    }

    private static int indexOf(Object[] array, Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (!element.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static String typeToString(Type type) {
        String string;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            string = clazz.getName();
        } else {
            string = type.toString();
        }
        return string;
    }

    public Class<? super T> getRawType() {
        return this.rawType;
    }

    public Type getType() {
        return this.type;
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        private final Type[] actualTypeArguments;

        private ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type ... actualTypeArguments) {
            Class rawClass;
            Objects.requireNonNull(rawType, "rawType cannot be null");
            if (ownerType == null && rawType instanceof Class && !Modifier.isStatic((rawClass = (Class)rawType).getModifiers()) && rawClass.getEnclosingClass() != null) {
                throw new NullPointerException("type %s requires an owner type".formatted(rawType));
            }
            Objects.requireNonNull(actualTypeArguments, "actualTypeArguments cannot be null");
            if (Arrays.stream(actualTypeArguments).anyMatch(Objects::isNull)) {
                throw new NullPointerException("elements of actualTypeArguments cannot be null.");
            }
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.actualTypeArguments = Arrays.copyOf(actualTypeArguments, actualTypeArguments.length);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return Arrays.copyOf(this.actualTypeArguments, this.actualTypeArguments.length);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParameterizedTypeImpl)) {
                return false;
            }
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
            return Objects.equals(this.ownerType, that.ownerType) && Objects.equals(this.rawType, that.rawType) && Arrays.equals(this.actualTypeArguments, that.actualTypeArguments);
        }

        public int hashCode() {
            return Arrays.hashCode(this.actualTypeArguments) ^ this.rawType.hashCode() ^ (this.ownerType != null ? this.ownerType.hashCode() : 0);
        }

        public String toString() {
            return TypeToken.typeToString(this.rawType) + "<" + Arrays.stream(this.actualTypeArguments).map(TypeToken::typeToString).collect(Collectors.joining(", ")) + ">";
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }
    }

    private static class GenericArrayTypeImpl
    implements GenericArrayType {
        @NonNull
        private final Type genericComponentType;

        public boolean equals(Object obj) {
            GenericArrayType gt;
            return obj instanceof GenericArrayType && Objects.equals(this.genericComponentType, (gt = (GenericArrayType)obj).getGenericComponentType());
        }

        public int hashCode() {
            return this.genericComponentType.hashCode();
        }

        public String toString() {
            return TypeToken.typeToString(this.genericComponentType) + "[]";
        }

        @Override
        @NonNull
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public GenericArrayTypeImpl(@NonNull Type genericComponentType) {
            if (genericComponentType == null) {
                throw new NullPointerException("genericComponentType is marked non-null but is null");
            }
            this.genericComponentType = genericComponentType;
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private static final Type[] EMPTY = new Type[0];
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            Type[] typeArray;
            if (upperBounds != null && upperBounds.length > 0) {
                typeArray = Arrays.copyOf(upperBounds, upperBounds.length);
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            }
            this.upperBounds = typeArray;
            this.lowerBounds = lowerBounds != null && lowerBounds.length > 0 ? Arrays.copyOf(lowerBounds, lowerBounds.length) : EMPTY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WildcardTypeImpl)) {
                return false;
            }
            WildcardTypeImpl that = (WildcardTypeImpl)o;
            return Arrays.equals(this.upperBounds, that.upperBounds) && Arrays.equals(this.lowerBounds, that.lowerBounds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
        }

        public String toString() {
            if (this.lowerBounds.length > 0) {
                return "? super " + Arrays.stream(this.lowerBounds).map(TypeToken::typeToString).collect(Collectors.joining(" & "));
            }
            if (this.upperBounds.length == 0 || this.upperBounds[0] == Object.class) {
                return "?";
            }
            return "? extends " + Arrays.stream(this.upperBounds).map(TypeToken::typeToString).collect(Collectors.joining(" & "));
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }
    }
}

