/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ObjectDeserializer
implements TypeDeserializer<Object> {
    public static final ObjectDeserializer INSTANCE = new ObjectDeserializer();

    @Override
    public Object read(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case COMPOUND: {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                reader.beginCompound();
                while (reader.hasNext()) {
                    map.put(reader.name(), this.read(reader));
                }
                reader.endCompound();
                return map;
            }
            case LIST: {
                ArrayList<Object> list = new ArrayList<Object>(reader.beginList());
                while (reader.hasNext()) {
                    list.add(this.read(reader));
                }
                reader.endList();
                return list;
            }
            case STRING: {
                return reader.nextString();
            }
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return reader.nextLong();
            }
            case FLOAT: {
                return Float.valueOf(reader.nextFloat());
            }
            case DOUBLE: {
                return reader.nextDouble();
            }
            case BYTE_ARRAY: {
                return reader.nextByteArray();
            }
            case INT_ARRAY: {
                return reader.nextIntArray();
            }
            case LONG_ARRAY: {
                return reader.nextLongArray();
            }
        }
        throw new IllegalStateException("Found unexpected " + String.valueOf((Object)type) + " tag.");
    }
}

