/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.airlift.compress.zstd;

import de.bluecolored.shadow.airlift.compress.hadoop.HadoopInputStream;
import de.bluecolored.shadow.airlift.compress.hadoop.HadoopOutputStream;
import de.bluecolored.shadow.airlift.compress.hadoop.HadoopStreams;
import de.bluecolored.shadow.airlift.compress.zstd.ZstdHadoopInputStream;
import de.bluecolored.shadow.airlift.compress.zstd.ZstdHadoopOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class ZstdHadoopStreams
implements HadoopStreams {
    @Override
    public String getDefaultFileExtension() {
        return ".zst";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.ZStandardCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new ZstdHadoopInputStream(in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZstdHadoopOutputStream(out);
    }
}

