/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.typesafe.config.impl;

import de.bluecolored.shadow.typesafe.config.ConfigOrigin;
import de.bluecolored.shadow.typesafe.config.ConfigValueType;
import de.bluecolored.shadow.typesafe.config.impl.ConfigNumber;
import de.bluecolored.shadow.typesafe.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigInt
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final int value;

    ConfigInt(ConfigOrigin origin, int value, String originalText) {
        super(origin, originalText);
        this.value = value;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Integer unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s2 = super.transformToString();
        if (s2 == null) {
            return Integer.toString(this.value);
        }
        return s2;
    }

    @Override
    protected long longValue() {
        return this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigInt newCopy(ConfigOrigin origin) {
        return new ConfigInt(origin, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

