/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.BlueCommands;
import de.bluecolored.bluecommands.CommandExecutable;
import de.bluecolored.bluecommands.CommandSetupException;
import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Priority;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.function.Function;

public class MethodCommandExecutable<C>
implements CommandExecutable<C, Object> {
    private final Method method;
    private final Object holder;
    private final int priority;
    private final BlueCommands<C> blueCommands;

    public MethodCommandExecutable(Method method, Object holder, BlueCommands<C> blueCommands) {
        this.method = method;
        this.holder = holder;
        this.blueCommands = blueCommands;
        this.method.setAccessible(true);
        Priority priority = method.getAnnotation(Priority.class);
        this.priority = priority != null ? priority.value() : 0;
    }

    @Override
    public Object execute(C context, Map<String, Object> arguments) {
        Parameter[] parameters = this.method.getParameters();
        Object[] parameterValues = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Argument argument = parameter.getAnnotation(Argument.class);
            if (argument != null) {
                parameterValues[i] = arguments.get(argument.value());
                continue;
            }
            Function<C, ?> contextResolver = this.blueCommands.getContextResolver(parameter.getType());
            if (contextResolver != null) {
                parameterValues[i] = contextResolver.apply(context);
                continue;
            }
            if (parameter.getType().isInstance(context)) {
                parameterValues[i] = context;
                continue;
            }
            throw new CommandSetupException("Failed to resolve parameter for command execution.\nMethod: " + this.method + "\nParameter: " + parameter);
        }
        try {
            return this.method.invoke(this.holder, parameterValues);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CommandSetupException("Failed to invoke method for command execution!\nMethod:" + this.method, e);
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isValid(C context) {
        return this.blueCommands.checkContext(context, this.method);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getHolder() {
        return this.holder;
    }
}

