/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.AssetStorage;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import lombok.NonNull;

public class AssetStorageImpl
implements AssetStorage {
    private final MapStorage storage;
    private final String mapId;

    public AssetStorageImpl(MapStorage storage, String mapId) {
        this.storage = storage;
        this.mapId = mapId;
    }

    @Override
    public OutputStream writeAsset(@NonNull String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.storage.asset(name).write();
    }

    @Override
    public Optional<InputStream> readAsset(@NonNull String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        CompressedInputStream in = this.storage.asset(name).read();
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(in.decompress());
    }

    @Override
    public boolean assetExists(@NonNull String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.storage.asset(name).exists();
    }

    @Override
    public String getAssetUrl(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return "maps/" + this.mapId + "/assets/" + MapStorage.escapeAssetName(name);
    }

    @Override
    public void deleteAsset(@NonNull String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.storage.asset(name).delete();
    }
}

