/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.adventure.adventure.text.TextComponent;
import de.bluecolored.shadow.adventure.adventure.text.event.ClickEvent;
import de.bluecolored.shadow.adventure.adventure.text.event.HoverEventSource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class TileNoRenderErrorCheck
implements Check {
    private final BmMap map;
    private final Vector2i position;
    private final Vector2i tile;
    private final TileInfoRegion.TileInfo tileInfo;

    public TileNoRenderErrorCheck(BmMap map, Vector2i position) {
        this.map = map;
        this.position = position;
        this.tile = map.getHiresModelManager().getTileGrid().getCell(position);
        this.tileInfo = map.getMapTileState().get(this.tile.getX(), this.tile.getY());
    }

    @Override
    public CheckResult getResult() {
        return this.tileInfo.getState() != TileState.RENDER_ERROR ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        LocalDateTime failureTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(this.tileInfo.getRenderTime()), ZoneId.systemDefault());
        return TextFormat.lines(TextFormat.format("\u26a0 there was an error while rendering\naround (x:%, z:%) for map %\n".strip(), Component.text(this.position.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text(this.position.getY()).color(TextFormat.HIGHLIGHT_COLOR), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("check your server-logs for errors\naround %\n\nif the problem persists, you can visit bluemaps % for help\n".strip(), Component.text(TextFormat.DATE_TIME_FORMAT.format(failureTime)).color(TextFormat.HIGHLIGHT_COLOR), ((TextComponent)((TextComponent)Component.text("discord").hoverEvent((HoverEventSource)Component.text("https://discord.gg/zmkyJa3"))).clickEvent(ClickEvent.openUrl("https://discord.gg/zmkyJa3"))).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public Vector2i getTile() {
        return this.tile;
    }

    public TileInfoRegion.TileInfo getTileInfo() {
        return this.tileInfo;
    }

    public TileNoRenderErrorCheck(BmMap map, Vector2i position, Vector2i tile, TileInfoRegion.TileInfo tileInfo) {
        this.map = map;
        this.position = position;
        this.tile = tile;
        this.tileInfo = tileInfo;
    }
}

