/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.shadow.adventure.adventure.text.Component;

public class WorldHasMapsCheck
implements Check {
    private final ServerWorld world;
    private final BmMap[] maps;

    public WorldHasMapsCheck(Plugin plugin, ServerWorld world) {
        this.world = world;
        this.maps = (BmMap[])plugin.getBlueMap().getMaps().values().stream().filter(m4 -> m4.getWorld().getId().equals(this.getWorldId())).toArray(BmMap[]::new);
    }

    public String getWorldId() {
        return World.id(this.world.getWorldFolder(), this.world.getDimension());
    }

    @Override
    public CheckResult getResult() {
        return this.maps.length > 0 ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        return TextFormat.lines(Component.text("\u26a0 there are no maps configured for"), Component.text("your current world"), Component.empty(), this.mapWorldConfigInfo());
    }

    private Component mapWorldConfigInfo() {
        return TextFormat.format("to configure a map for your current world,\nmake sure to set\n%\nin the maps config file\n".strip(), this.formatWorldConfig().color(TextFormat.INFO_COLOR)).color(TextFormat.BASE_COLOR);
    }

    private Component formatWorldConfig() {
        return TextFormat.format("\u250c\n\u2502 world: \"%\"\n\u2502 dimension: \"%\"\n\u2514\n".strip(), BlueMapConfigManager.formatPath(this.world.getWorldFolder()), this.world.getDimension().getFormatted());
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public BmMap[] getMaps() {
        return this.maps;
    }
}

