/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.bluemap.common.BlueMapConfiguration;
import de.bluecolored.bluemap.common.config.ConfigManager;
import de.bluecolored.bluemap.common.config.ConfigTemplate;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.CoreConfig;
import de.bluecolored.bluemap.common.config.MapConfig;
import de.bluecolored.bluemap.common.config.PluginConfig;
import de.bluecolored.bluemap.common.config.WebappConfig;
import de.bluecolored.bluemap.common.config.WebserverConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class BlueMapConfigManager
implements BlueMapConfiguration {
    public static final String CORE_CONFIG_NAME = "core";
    public static final String WEBSERVER_CONFIG_NAME = "webserver";
    public static final String WEBAPP_CONFIG_NAME = "webapp";
    public static final String PLUGIN_CONFIG_NAME = "plugin";
    public static final String MAPS_CONFIG_FOLDER_NAME = "maps";
    public static final String STORAGES_CONFIG_FOLDER_NAME = "storages";
    public static final String MAP_STORAGE_CONFIG_NAME = "maps/map";
    public static final String FILE_STORAGE_CONFIG_NAME = "storages/file";
    public static final String SQL_STORAGE_CONFIG_NAME = "storages/sql";
    private final ConfigManager configManager;
    private final CoreConfig coreConfig;
    private final WebserverConfig webserverConfig;
    private final WebappConfig webappConfig;
    private final PluginConfig pluginConfig;
    private final Map<String, MapConfig> mapConfigs;
    private final Map<String, StorageConfig> storageConfigs;
    private final Path packsFolder;
    @Nullable
    private final String minecraftVersion;
    @Nullable
    private final Path modsFolder;

    private BlueMapConfigManager(@NonNull Path configRoot, @Nullable String minecraftVersion, @Nullable Path defaultDataFolder, @Nullable Path defaultWebroot, @Nullable Collection<ServerWorld> autoConfigWorlds, @Nullable Boolean usePluginConfig, @Nullable Boolean useMetricsConfig, @Nullable Path packsFolder, @Nullable Path modsFolder) throws ConfigurationException {
        if (configRoot == null) {
            throw new NullPointerException("configRoot is marked non-null but is null");
        }
        if (defaultDataFolder == null) {
            defaultDataFolder = Path.of("bluemap", new String[0]);
        }
        if (defaultWebroot == null) {
            defaultWebroot = Path.of("bluemap", "web");
        }
        if (autoConfigWorlds == null) {
            autoConfigWorlds = Collections.emptyList();
        }
        if (usePluginConfig == null) {
            usePluginConfig = true;
        }
        if (useMetricsConfig == null) {
            useMetricsConfig = true;
        }
        if (packsFolder == null) {
            packsFolder = configRoot.resolve("packs");
        }
        this.configManager = new ConfigManager(configRoot);
        this.coreConfig = this.loadCoreConfig(defaultDataFolder, useMetricsConfig);
        this.webappConfig = this.loadWebappConfig(defaultWebroot);
        this.webserverConfig = this.loadWebserverConfig(this.webappConfig.getWebroot(), this.coreConfig.getData());
        this.pluginConfig = usePluginConfig != false ? this.loadPluginConfig() : new PluginConfig();
        this.storageConfigs = Collections.unmodifiableMap(this.loadStorageConfigs(this.webappConfig.getWebroot()));
        this.mapConfigs = Collections.unmodifiableMap(this.loadMapConfigs(autoConfigWorlds));
        this.packsFolder = packsFolder;
        this.minecraftVersion = minecraftVersion;
        this.modsFolder = modsFolder;
    }

    private CoreConfig loadCoreConfig(Path defaultDataFolder, boolean useMetricsConfig) throws ConfigurationException {
        Path configFile = this.configManager.resolveConfigFile(CORE_CONFIG_NAME);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFile, (CharSequence)this.configManager.loadConfigTemplate(CORE_CONFIG_NAME).setConditional("metrics", useMetricsConfig).setVariable("timestamp", LocalDateTime.now().withNano(0).toString()).setVariable("version", BlueMap.VERSION).setVariable("mcVersion", this.minecraftVersion).setVariable("data", BlueMapConfigManager.formatPath(defaultDataFolder)).setVariable("implementation", "bukkit").setVariable("render-thread-count", Integer.toString(this.suggestRenderThreadCount())).setVariable("logfile", BlueMapConfigManager.formatPath(defaultDataFolder.resolve("logs").resolve("debug.log"))).setVariable("logfile-with-time", BlueMapConfigManager.formatPath(defaultDataFolder.resolve("logs").resolve("debug_%1$tF_%1$tT.log"))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default core-configuration-file: " + String.valueOf(ex));
            }
        }
        return this.configManager.loadConfig(CORE_CONFIG_NAME, CoreConfig.class);
    }

    private int suggestRenderThreadCount() {
        Runtime runtime = Runtime.getRuntime();
        int availableCores = runtime.availableProcessors();
        long availableMemoryMiB = runtime.maxMemory() / 1024L / 1024L;
        int presetRenderThreadCount = 1;
        if (availableCores >= 6 && availableMemoryMiB >= 4096L) {
            presetRenderThreadCount = 2;
        }
        if (availableCores >= 10 && availableMemoryMiB >= 8192L) {
            presetRenderThreadCount = 3;
        }
        return presetRenderThreadCount;
    }

    private WebserverConfig loadWebserverConfig(Path defaultWebroot, Path dataRoot) throws ConfigurationException {
        Path configFile = this.configManager.resolveConfigFile(WEBSERVER_CONFIG_NAME);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFile, (CharSequence)this.configManager.loadConfigTemplate(WEBSERVER_CONFIG_NAME).setVariable("webroot", BlueMapConfigManager.formatPath(defaultWebroot)).setVariable("logfile", BlueMapConfigManager.formatPath(dataRoot.resolve("logs").resolve("webserver.log"))).setVariable("logfile-with-time", BlueMapConfigManager.formatPath(dataRoot.resolve("logs").resolve("webserver_%1$tF_%1$tT.log"))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webserver-configuration-file: " + String.valueOf(ex));
            }
        }
        return this.configManager.loadConfig(WEBSERVER_CONFIG_NAME, WebserverConfig.class);
    }

    private WebappConfig loadWebappConfig(Path defaultWebroot) throws ConfigurationException {
        Path configFile = this.configManager.resolveConfigFile(WEBAPP_CONFIG_NAME);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFile, (CharSequence)this.configManager.loadConfigTemplate(WEBAPP_CONFIG_NAME).setVariable("webroot", BlueMapConfigManager.formatPath(defaultWebroot)).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webapp-configuration-file: " + String.valueOf(ex));
            }
        }
        return this.configManager.loadConfig(WEBAPP_CONFIG_NAME, WebappConfig.class);
    }

    private PluginConfig loadPluginConfig() throws ConfigurationException {
        Path configFile = this.configManager.resolveConfigFile(PLUGIN_CONFIG_NAME);
        Path configFolder = configFile.getParent();
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(configFolder, new FileAttribute[0]);
                Files.writeString(configFile, (CharSequence)this.configManager.loadConfigTemplate(PLUGIN_CONFIG_NAME).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                Logger.global.logWarning("Failed to create default webapp-configuration-file: " + String.valueOf(ex));
            }
        }
        return this.configManager.loadConfig(PLUGIN_CONFIG_NAME, PluginConfig.class);
    }

    private Map<String, MapConfig> loadMapConfigs(Collection<ServerWorld> autoConfigWorlds) throws ConfigurationException {
        HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
        Path mapConfigFolder = this.configManager.getConfigRoot().resolve(MAPS_CONFIG_FOLDER_NAME);
        if (!Files.exists(mapConfigFolder, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(mapConfigFolder, new FileAttribute[0]);
                if (autoConfigWorlds.isEmpty()) {
                    Path worldFolder = Path.of("world", new String[0]);
                    Files.writeString(this.configManager.resolveConfigFile("maps/overworld"), (CharSequence)this.createOverworldMapTemplate("Overworld", worldFolder, DataPack.DIMENSION_OVERWORLD, 0).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.writeString(this.configManager.resolveConfigFile("maps/nether"), (CharSequence)this.createNetherMapTemplate("Nether", worldFolder, DataPack.DIMENSION_THE_NETHER, 100).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.writeString(this.configManager.resolveConfigFile("maps/end"), (CharSequence)this.createEndMapTemplate("End", worldFolder, DataPack.DIMENSION_THE_END, 200).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                } else {
                    ArrayList<ServerWorld> overworldFirstAutoConfigWorlds = new ArrayList<ServerWorld>(autoConfigWorlds.size());
                    overworldFirstAutoConfigWorlds.addAll(autoConfigWorlds);
                    overworldFirstAutoConfigWorlds.sort(Comparator.comparingInt(w -> DataPack.DIMENSION_OVERWORLD.equals(w.getDimension()) ? 0 : 1));
                    HashSet<String> mapIds = new HashSet<String>();
                    for (ServerWorld world : overworldFirstAutoConfigWorlds) {
                        Path worldFolder = world.getWorldFolder().normalize();
                        Key dimension = world.getDimension();
                        String dimensionName = dimension.getNamespace().equals("minecraft") ? dimension.getValue() : dimension.getFormatted();
                        String id = this.sanitiseMapId(worldFolder.getFileName().toString()).toLowerCase(Locale.ROOT);
                        if (mapIds.contains(id)) {
                            id = this.sanitiseMapId(String.valueOf(worldFolder.getFileName()) + "_" + dimensionName).toLowerCase(Locale.ROOT);
                        }
                        int i = 1;
                        Object uniqueId = id;
                        while (mapIds.contains(uniqueId)) {
                            uniqueId = id + "_" + ++i;
                        }
                        mapIds.add((String)uniqueId);
                        Path configFile = this.configManager.resolveConfigFile("maps/" + (String)uniqueId);
                        String name = String.valueOf(worldFolder.getFileName()) + " (" + dimensionName + ")";
                        if (i > 1) {
                            name = name + " (" + i + ")";
                        }
                        ConfigTemplate template = switch (world.getDimension().getFormatted()) {
                            case "minecraft:overworld" -> this.createOverworldMapTemplate(name, worldFolder, dimension, i - 1);
                            case "minecraft:the_nether" -> this.createNetherMapTemplate(name, worldFolder, dimension, i - 1 + 100);
                            case "minecraft:the_end" -> this.createEndMapTemplate(name, worldFolder, dimension, i - 1 + 200);
                            default -> this.createOverworldMapTemplate(name, worldFolder, dimension, i - 1 + 300);
                        };
                        Files.writeString(configFile, (CharSequence)template.build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    }
                }
            }
            catch (IOException | NullPointerException ex) {
                throw new ConfigurationException("BlueMap failed to create default map-configuration-files in\n" + String.valueOf(mapConfigFolder.toAbsolutePath().normalize()) + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
            }
        }
        try (Stream<Path> configFiles = Files.list(mapConfigFolder);){
            for (Path configFile : (Path[])configFiles.toArray(Path[]::new)) {
                if (!this.configManager.isConfigFile(configFile)) continue;
                String id = this.sanitiseMapId(this.configManager.getConfigName(configFile));
                if (mapConfigs.containsKey(id)) {
                    throw new ConfigurationException("At least two of your map-config file-names result in ambiguous map-id's!\n" + String.valueOf(configFile.toAbsolutePath().normalize()) + "\nTo resolve this issue, rename this file to something else.");
                }
                try {
                    MapConfig mapConfig = this.configManager.loadConfig(configFile, MapConfig.class);
                    mapConfig.checkLegacy();
                    mapConfigs.put(id, mapConfig);
                }
                catch (ConfigurationException ex) {
                    throw new ConfigurationException("Failed to load map-config:\n" + String.valueOf(configFile.toAbsolutePath().normalize()), ex);
                }
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("BlueMap failed to read your map configuration from\n" + String.valueOf(mapConfigFolder.toAbsolutePath().normalize()) + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
        }
        return mapConfigs;
    }

    private Map<String, StorageConfig> loadStorageConfigs(Path defaultWebroot) throws ConfigurationException {
        HashMap<String, StorageConfig> storageConfigs = new HashMap<String, StorageConfig>();
        Path storageConfigFolder = this.configManager.getConfigRoot().resolve(STORAGES_CONFIG_FOLDER_NAME);
        if (!Files.exists(storageConfigFolder, new LinkOption[0])) {
            try {
                FileHelper.createDirectories(storageConfigFolder, new FileAttribute[0]);
                Files.writeString(this.configManager.resolveConfigFile(FILE_STORAGE_CONFIG_NAME), (CharSequence)this.configManager.loadConfigTemplate(FILE_STORAGE_CONFIG_NAME).setVariable("root", BlueMapConfigManager.formatPath(defaultWebroot.resolve(MAPS_CONFIG_FOLDER_NAME))).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                Files.writeString(this.configManager.resolveConfigFile(SQL_STORAGE_CONFIG_NAME), (CharSequence)this.configManager.loadConfigTemplate(SQL_STORAGE_CONFIG_NAME).build(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException | NullPointerException ex) {
                throw new ConfigurationException("BlueMap failed to create default storage-configuration-files in\n" + String.valueOf(storageConfigFolder.toAbsolutePath().normalize()) + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
            }
        }
        try (Stream<Path> configFiles = Files.list(storageConfigFolder);){
            for (Path configFile : (Path[])configFiles.toArray(Path[]::new)) {
                if (!this.configManager.isConfigFile(configFile)) continue;
                String id = this.configManager.getConfigName(configFile);
                StorageConfig storageConfig = this.configManager.loadConfig(configFile, StorageConfig.Base.class);
                storageConfig = this.configManager.loadConfig(configFile, storageConfig.getStorageType().getConfigType());
                storageConfigs.put(id, storageConfig);
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("BlueMap failed to read your map configuration from\n" + String.valueOf(storageConfigFolder.toAbsolutePath().normalize()) + "\nCheck if BlueMap has the permission to create and read from this folder.", ex);
        }
        return storageConfigs;
    }

    private String sanitiseMapId(String id) {
        return id.replaceAll("\\W", "_");
    }

    private ConfigTemplate createOverworldMapTemplate(String name, Path worldFolder, Key dimension, int sorting) throws IOException {
        return this.configManager.loadConfigTemplate(MAP_STORAGE_CONFIG_NAME).setVariable("name", name).setVariable("sorting", "" + sorting).setVariable("world", BlueMapConfigManager.formatPath(worldFolder)).setVariable("dimension", dimension.getFormatted()).setVariable("sky-color", "#7dabff").setVariable("void-color", "#000000").setVariable("ambient-light", "0.1").setVariable("remove-caves-below-y", "55").setConditional("remove-nether-ceiling", false);
    }

    private ConfigTemplate createNetherMapTemplate(String name, Path worldFolder, Key dimension, int sorting) throws IOException {
        return this.configManager.loadConfigTemplate(MAP_STORAGE_CONFIG_NAME).setVariable("name", name).setVariable("sorting", "" + sorting).setVariable("world", BlueMapConfigManager.formatPath(worldFolder)).setVariable("dimension", dimension.getFormatted()).setVariable("sky-color", "#290000").setVariable("void-color", "#150000").setVariable("ambient-light", "0.6").setVariable("remove-caves-below-y", "-10000").setConditional("remove-nether-ceiling", true);
    }

    private ConfigTemplate createEndMapTemplate(String name, Path worldFolder, Key dimension, int sorting) throws IOException {
        return this.configManager.loadConfigTemplate(MAP_STORAGE_CONFIG_NAME).setVariable("name", name).setVariable("sorting", "" + sorting).setVariable("world", BlueMapConfigManager.formatPath(worldFolder)).setVariable("dimension", dimension.getFormatted()).setVariable("sky-color", "#080010").setVariable("void-color", "#080010").setVariable("ambient-light", "0.6").setVariable("remove-caves-below-y", "-10000").setConditional("remove-nether-ceiling", false);
    }

    public static String formatPath(Path path) {
        String pathString;
        path = Path.of("", new String[0]).toAbsolutePath().relativize(path.toAbsolutePath()).normalize();
        String formatted = pathString = path.toString();
        String separator = FileSystems.getDefault().getSeparator();
        if (!separator.equals("/")) {
            formatted = pathString.replace(separator, "/");
        }
        if (!Path.of(formatted, new String[0]).equals(path)) {
            formatted = pathString;
        }
        formatted = formatted.replace("\\", "\\\\");
        return formatted;
    }

    public static BlueMapConfigManagerBuilder builder() {
        return new BlueMapConfigManagerBuilder();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    @Override
    public WebserverConfig getWebserverConfig() {
        return this.webserverConfig;
    }

    @Override
    public WebappConfig getWebappConfig() {
        return this.webappConfig;
    }

    @Override
    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @Override
    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    @Override
    public Map<String, StorageConfig> getStorageConfigs() {
        return this.storageConfigs;
    }

    @Override
    public Path getPacksFolder() {
        return this.packsFolder;
    }

    @Override
    @Nullable
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    @Nullable
    public Path getModsFolder() {
        return this.modsFolder;
    }

    public static class BlueMapConfigManagerBuilder {
        private Path configRoot;
        private String minecraftVersion;
        private Path defaultDataFolder;
        private Path defaultWebroot;
        private Collection<ServerWorld> autoConfigWorlds;
        private Boolean usePluginConfig;
        private Boolean useMetricsConfig;
        private Path packsFolder;
        private Path modsFolder;

        BlueMapConfigManagerBuilder() {
        }

        public BlueMapConfigManagerBuilder configRoot(@NonNull Path configRoot) {
            if (configRoot == null) {
                throw new NullPointerException("configRoot is marked non-null but is null");
            }
            this.configRoot = configRoot;
            return this;
        }

        public BlueMapConfigManagerBuilder minecraftVersion(@Nullable String minecraftVersion) {
            this.minecraftVersion = minecraftVersion;
            return this;
        }

        public BlueMapConfigManagerBuilder defaultDataFolder(@Nullable Path defaultDataFolder) {
            this.defaultDataFolder = defaultDataFolder;
            return this;
        }

        public BlueMapConfigManagerBuilder defaultWebroot(@Nullable Path defaultWebroot) {
            this.defaultWebroot = defaultWebroot;
            return this;
        }

        public BlueMapConfigManagerBuilder autoConfigWorlds(@Nullable Collection<ServerWorld> autoConfigWorlds) {
            this.autoConfigWorlds = autoConfigWorlds;
            return this;
        }

        public BlueMapConfigManagerBuilder usePluginConfig(@Nullable Boolean usePluginConfig) {
            this.usePluginConfig = usePluginConfig;
            return this;
        }

        public BlueMapConfigManagerBuilder useMetricsConfig(@Nullable Boolean useMetricsConfig) {
            this.useMetricsConfig = useMetricsConfig;
            return this;
        }

        public BlueMapConfigManagerBuilder packsFolder(@Nullable Path packsFolder) {
            this.packsFolder = packsFolder;
            return this;
        }

        public BlueMapConfigManagerBuilder modsFolder(@Nullable Path modsFolder) {
            this.modsFolder = modsFolder;
            return this;
        }

        public BlueMapConfigManager build() throws ConfigurationException {
            return new BlueMapConfigManager(this.configRoot, this.minecraftVersion, this.defaultDataFolder, this.defaultWebroot, this.autoConfigWorlds, this.usePluginConfig, this.useMetricsConfig, this.packsFolder, this.modsFolder);
        }

        public String toString() {
            return "BlueMapConfigManager.BlueMapConfigManagerBuilder(configRoot=" + String.valueOf(this.configRoot) + ", minecraftVersion=" + this.minecraftVersion + ", defaultDataFolder=" + String.valueOf(this.defaultDataFolder) + ", defaultWebroot=" + String.valueOf(this.defaultWebroot) + ", autoConfigWorlds=" + String.valueOf(this.autoConfigWorlds) + ", usePluginConfig=" + this.usePluginConfig + ", useMetricsConfig=" + this.useMetricsConfig + ", packsFolder=" + String.valueOf(this.packsFolder) + ", modsFolder=" + String.valueOf(this.modsFolder) + ")";
        }
    }
}

