/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.core.map.mask.EllipseMask;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;

@ConfigSerializable
public class EllipseMaskConfig
extends MaskConfig {
    private double centerX = 0.0;
    private double centerZ = 0.0;
    private double radiusX = Double.MAX_VALUE;
    private double radiusZ = Double.MAX_VALUE;
    private int minY = Integer.MIN_VALUE;
    private int maxY = Integer.MAX_VALUE;

    @Override
    public Mask createMask() throws ConfigurationException {
        if (this.minY > this.maxY) {
            throw new ConfigurationException("The circle-mask configuration results in a degenerate mask.\nMake sure that the \"min-y\" value is actually SMALLER than the \"max-y\" counterpart.\n".trim());
        }
        if (this.radiusX <= 0.0 || this.radiusZ <= 0.0) {
            throw new ConfigurationException("The ellipse-mask configuration results in a degenerate mask.\nMake sure that the radius values are greater than 0.\n".trim());
        }
        return new EllipseMask(new Vector2d(this.centerX, this.centerZ), this.radiusX, this.radiusZ, this.minY, this.maxY);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }
}

