/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.mask;

import de.bluecolored.bluemap.common.config.mask.BlurMaskConfig;
import de.bluecolored.bluemap.common.config.mask.BoxMaskConfig;
import de.bluecolored.bluemap.common.config.mask.CircleMaskConfig;
import de.bluecolored.bluemap.common.config.mask.EllipseMaskConfig;
import de.bluecolored.bluemap.common.config.mask.MaskConfig;
import de.bluecolored.bluemap.common.config.mask.PolygonMaskConfig;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;

public interface MaskType
extends Keyed {
    public static final MaskType BOX = new Impl(Key.bluemap("box"), BoxMaskConfig.class);
    public static final MaskType CIRCLE = new Impl(Key.bluemap("circle"), CircleMaskConfig.class);
    public static final MaskType ELLIPSE = new Impl(Key.bluemap("ellipse"), EllipseMaskConfig.class);
    public static final MaskType POLYGON = new Impl(Key.bluemap("polygon"), PolygonMaskConfig.class);
    public static final MaskType BLUR = new Impl(Key.bluemap("blur"), BlurMaskConfig.class);
    public static final Registry<MaskType> REGISTRY = new Registry((Keyed[])new MaskType[]{BOX, CIRCLE, ELLIPSE, POLYGON, BLUR});

    public Class<? extends MaskConfig> getConfigType();

    public static class Impl
    implements MaskType {
        private final Key key;
        private final Class<? extends MaskConfig> configType;

        public Impl(Key key, Class<? extends MaskConfig> configType) {
            this.key = key;
            this.configType = configType;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Class<? extends MaskConfig> getConfigType() {
            return this.configType;
        }
    }
}

