/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.entity;

import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRenderer;
import de.bluecolored.bluemap.core.map.hires.entity.EntityRendererFactory;
import de.bluecolored.bluemap.core.map.hires.entity.MissingModelRenderer;
import de.bluecolored.bluemap.core.map.hires.entity.ResourceModelRenderer;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;

public interface EntityRendererType
extends Keyed,
EntityRendererFactory {
    public static final EntityRendererType DEFAULT = new Impl(Key.bluemap("default"), ResourceModelRenderer::new);
    public static final EntityRendererType MISSING = new Impl(Key.bluemap("missing"), MissingModelRenderer::new);
    public static final Registry<EntityRendererType> REGISTRY = new Registry((Keyed[])new EntityRendererType[]{DEFAULT, MISSING});

    default public boolean isFallbackFor(Key entityType) {
        return false;
    }

    public static class Impl
    implements EntityRendererType {
        private final Key key;
        private final EntityRendererFactory rendererFactory;

        @Override
        public EntityRenderer create(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
            return this.rendererFactory.create(resourcePack, textureGallery, renderSettings);
        }

        public Impl(Key key, EntityRendererFactory rendererFactory) {
            this.key = key;
            this.rendererFactory = rendererFactory;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

