/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.PackMeta;
import de.bluecolored.bluemap.core.resources.pack.PackVersion;
import de.bluecolored.bluemap.core.util.FileHelper;
import de.bluecolored.bluemap.core.util.Key;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class Pack {
    private final PackVersion packVersion;
    @Nullable
    private final Set<Key> enabledFeatures;

    public Pack(PackVersion packVersion) {
        this(packVersion, null);
    }

    public abstract void loadResources(Iterable<Path> var1) throws IOException, InterruptedException;

    public void loadResourcePath(Path root, Loader resourceLoader) throws IOException, InterruptedException {
        PackMeta packMeta;
        Path packMetaFile;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!Files.isDirectory(root, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(root, (ClassLoader)null);){
                for (Path fsRoot : fileSystem.getRootDirectories()) {
                    if (!Files.isDirectory(fsRoot, new LinkOption[0])) continue;
                    this.loadResourcePath(fsRoot, resourceLoader);
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read '" + String.valueOf(root) + "': " + String.valueOf(ex));
            }
            return;
        }
        Path fabricModJson = root.resolve("fabric.mod.json");
        if (Files.isRegularFile(fabricModJson, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(fabricModJson);){
                JsonObject rootElement = (JsonObject)ResourcesGson.INSTANCE.fromJson((Reader)reader, JsonObject.class);
                if (rootElement.has("jars")) {
                    for (JsonElement element : rootElement.getAsJsonArray("jars")) {
                        Path file = root.resolve(element.getAsJsonObject().get("file").getAsString());
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        try {
                            this.loadResourcePath(file, resourceLoader);
                        }
                        catch (Exception ex) {
                            Logger.global.logDebug("Failed to read '" + String.valueOf(root) + "': " + String.valueOf(ex));
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read fabric.mod.json: " + String.valueOf(ex));
            }
        }
        if (Files.isRegularFile(packMetaFile = root.resolve("pack.mcmeta"), new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(packMetaFile);){
                packMeta = (PackMeta)ResourcesGson.INSTANCE.fromJson((Reader)reader, PackMeta.class);
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read pack.mcmeta: " + String.valueOf(ex));
                packMeta = new PackMeta();
            }
        } else {
            packMeta = new PackMeta();
        }
        if (this.enabledFeatures != null && !this.enabledFeatures.containsAll(packMeta.getFeatures().getEnabled())) {
            Logger.global.logDebug("Skipping resources from '%s' because not all required features (%s) are enabled (%s)".formatted(root, Arrays.toString(packMeta.getFeatures().getEnabled().toArray()), Arrays.toString(this.enabledFeatures.toArray())));
            return;
        }
        Pack.list(root.resolve("data")).map(namespaceRoot -> namespaceRoot.resolve("datapacks")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(Pack::list).forEach(nestedPack -> {
            try {
                this.loadResourcePath((Path)nestedPack, resourceLoader);
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to load nested datapack '" + String.valueOf(nestedPack) + "': " + String.valueOf(ex));
            }
        });
        PackMeta.Overlay[] overlays = packMeta.getOverlays().getEntries();
        for (int i = overlays.length - 1; i >= 0; --i) {
            Path overlayRoot;
            PackMeta.Overlay overlay = overlays[i];
            String dir = overlay.getDirectory();
            if (dir == null || !overlay.includes(this.packVersion) || !Files.exists(overlayRoot = root.resolve(dir), new LinkOption[0])) continue;
            try {
                this.loadResourcePath(overlayRoot, resourceLoader);
                continue;
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to load overlay '" + String.valueOf(overlayRoot) + "': " + String.valueOf(ex));
            }
        }
        resourceLoader.load(root);
    }

    public static Stream<Path> list(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.list(root);
    }

    public static Stream<Path> walk(Path root) {
        if (!Files.exists(root, new LinkOption[0])) {
            return Stream.empty();
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return Stream.of(root);
        }
        return FileHelper.walk(root, new FileVisitOption[0]);
    }

    public Pack(PackVersion packVersion, @Nullable Set<Key> enabledFeatures) {
        this.packVersion = packVersion;
        this.enabledFeatures = enabledFeatures;
    }

    public PackVersion getPackVersion() {
        return this.packVersion;
    }

    @Nullable
    public Set<Key> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public static interface Loader {
        public void load(Path var1) throws IOException;
    }
}

