/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import com.google.gson.annotations.SerializedName;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Source;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class UnstitchSource
extends Source {
    private ResourcePath<Texture> resource;
    @SerializedName(value="divisor_x")
    private double divisorX;
    @SerializedName(value="divisor_y")
    private double divisorY;
    private Set<Region> regions;

    @Override
    public void load(Path root, ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        if (this.resource == null) {
            return;
        }
        if (this.regions == null || this.regions.isEmpty()) {
            return;
        }
        textures.load(this.resource, resource -> {
            Path file = this.getFile(root, resource);
            return this.loadTexture(resource, file);
        });
    }

    @Override
    public void bake(ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        if (this.resource == null) {
            return;
        }
        if (this.regions == null || this.regions.isEmpty()) {
            return;
        }
        Texture texture = textures.get(this.resource);
        if (texture == null) {
            return;
        }
        BufferedImage image = texture.getTextureImage();
        if (this.divisorX <= 0.0) {
            this.divisorX = image.getWidth();
        }
        if (this.divisorY <= 0.0) {
            this.divisorY = image.getHeight();
        }
        double fX = (double)image.getWidth() / this.divisorX;
        double fY = (double)image.getHeight() / this.divisorY;
        for (Region region : this.regions) {
            if (region == null || textures.contains(region.sprite) || !textureFilter.test(region.sprite)) continue;
            try {
                BufferedImage regionImage = image.getSubimage((int)(region.x * fX), (int)(region.y * fY), (int)(region.width * fX), (int)(region.height * fY));
                textures.put(region.sprite, Texture.from(region.sprite, regionImage, texture.getAnimation()));
            }
            catch (RasterFormatException e) {
                Logger.global.logDebug("Failed to unstitch %s into %s because defined region is out of image-bounds: %s".formatted(this.resource, region.sprite, e));
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        UnstitchSource that = (UnstitchSource)object;
        return Double.compare(this.divisorX, that.divisorX) == 0 && Double.compare(this.divisorY, that.divisorY) == 0 && Objects.equals(this.resource, that.resource) && Objects.equals(this.regions, that.regions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.resource);
        result = 31 * result + Double.hashCode(this.divisorX);
        result = 31 * result + Double.hashCode(this.divisorY);
        result = 31 * result + Objects.hashCode(this.regions);
        return result;
    }

    public ResourcePath<Texture> getResource() {
        return this.resource;
    }

    public double getDivisorX() {
        return this.divisorX;
    }

    public double getDivisorY() {
        return this.divisorY;
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public UnstitchSource(ResourcePath<Texture> resource, double divisorX, double divisorY, Set<Region> regions) {
        this.resource = resource;
        this.divisorX = divisorX;
        this.divisorY = divisorY;
        this.regions = regions;
    }

    private UnstitchSource() {
    }

    public static class Region {
        private ResourcePath<Texture> sprite;
        private double x;
        private double y;
        private double width;
        private double height;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Region region = (Region)object;
            return Double.compare(this.x, region.x) == 0 && Double.compare(this.y, region.y) == 0 && Double.compare(this.width, region.width) == 0 && Double.compare(this.height, region.height) == 0 && Objects.equals(this.sprite, region.sprite);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.sprite);
            result = 31 * result + Double.hashCode(this.x);
            result = 31 * result + Double.hashCode(this.y);
            result = 31 * result + Double.hashCode(this.width);
            result = 31 * result + Double.hashCode(this.height);
            return result;
        }

        public ResourcePath<Texture> getSprite() {
            return this.sprite;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        private Region() {
        }

        public Region(ResourcePath<Texture> sprite, double x, double y, double width, double height) {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

