/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class PageSpliterator<T>
implements Spliterator<T> {
    private final IntFunction<T[]> pageSupplier;
    private T[] lastBatch;
    private int pos;
    private int page;

    public PageSpliterator(IntFunction<T[]> pageSupplier) {
        this.pageSupplier = pageSupplier;
    }

    @Override
    public synchronized boolean tryAdvance(Consumer<? super T> action) {
        if (!this.refill()) {
            return false;
        }
        action.accept(this.lastBatch[this.pos++]);
        return true;
    }

    @Override
    public synchronized Spliterator<T> trySplit() {
        if (!this.refill()) {
            return null;
        }
        int from = this.pos;
        this.pos = this.lastBatch.length;
        return Spliterators.spliterator(this.lastBatch, from, this.pos, this.characteristics());
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 0;
    }

    private synchronized boolean refill() {
        if (this.lastBatch != null && this.pos < this.lastBatch.length) {
            return true;
        }
        this.pos = 0;
        this.lastBatch = this.pageSupplier.apply(this.page++);
        return this.lastBatch != null && this.lastBatch.length > 0;
    }
}

