/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.jetbrains.annotations.Nullable;

public class BufferedImageUtil {
    public static boolean halfTransparent(BufferedImage image) {
        Color color = new Color();
        float[] buffer = null;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                buffer = BufferedImageUtil.readPixel(image, x, y, color, buffer);
                if (!(color.a > 0.0f) || !(color.a < 1.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public static Color averageColor(BufferedImage image) {
        Color average = new Color();
        Color color = new Color();
        float[] buffer = null;
        int count = 0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                buffer = BufferedImageUtil.readPixel(image, x, y, color, buffer);
                ++count;
                average.add(color.premultiplied());
            }
        }
        average.div(count);
        return average;
    }

    public static Color readPixel(BufferedImage image, int x, int y, @Nullable Color target) {
        BufferedImageUtil.readPixel(image, x, y, target, null);
        return target;
    }

    private static float[] readPixel(BufferedImage image, int x, int y, @Nullable Color target, float @Nullable [] buffer) {
        if (target == null) {
            target = new Color();
        }
        if (image.getType() == 10 || image.getType() == 0) {
            buffer = BufferedImageUtil.readPixelDirect(image, x, y, target, buffer);
        } else {
            BufferedImageUtil.readPixelDefault(image, x, y, target);
        }
        return buffer;
    }

    private static void readPixelDefault(BufferedImage image, int x, int y, Color target) {
        target.set(image.getRGB(x, y), image.getColorModel().isAlphaPremultiplied());
    }

    private static float[] readPixelDirect(RenderedImage image, int x, int y, Color target, float @Nullable [] buffer) {
        float b;
        buffer = image.getData().getPixel(x, y, buffer);
        float r = buffer[0] / 255.0f;
        float g2 = buffer.length >= 3 ? buffer[1] / 255.0f : r;
        float f = b = buffer.length >= 3 ? buffer[2] / 255.0f : r;
        float a = buffer.length >= 4 ? buffer[3] / 255.0f : (buffer.length == 2 ? buffer[1] / 255.0f : 1.0f);
        target.set(r, g2, b, a, image.getColorModel().isAlphaPremultiplied());
        return buffer;
    }
}

