/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.Nullable;

public class CopyingPathVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private final CopyOption[] options;
    @Nullable
    private Path sourcePath;

    public CopyingPathVisitor(Path target, CopyOption ... options) {
        this.targetPath = target;
        this.options = options;
    }

    public CopyingPathVisitor(@Nullable Path source, Path target, CopyOption ... options) {
        this.sourcePath = source;
        this.targetPath = target;
        this.options = options;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path source, BasicFileAttributes attributes) throws IOException {
        Path target;
        if (this.sourcePath == null) {
            this.sourcePath = source;
        }
        if (Files.notExists(target = this.resolveTarget(source), new LinkOption[0])) {
            Files.createDirectory(target, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path source, BasicFileAttributes attributes) throws IOException {
        Path target = this.resolveTarget(source);
        Files.copy(source, target, this.options);
        return FileVisitResult.CONTINUE;
    }

    private Path resolveTarget(Path source) {
        if (this.sourcePath == null) {
            return this.targetPath;
        }
        return this.targetPath.resolve(this.sourcePath.relativize(source).toString());
    }
}

