/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.util.math.Axis;
import java.util.Objects;

public enum Direction {
    UP(0, 1, 0, Axis.Y),
    DOWN(0, -1, 0, Axis.Y),
    NORTH(0, 0, -1, Axis.Z),
    SOUTH(0, 0, 1, Axis.Z),
    WEST(-1, 0, 0, Axis.X),
    EAST(1, 0, 0, Axis.X);

    private final Vector3i dir;
    private final Axis axis;
    private Direction opposite;
    private Direction left;
    private Direction right;
    private Direction localUp;

    private Direction(int x, int y, int z, Axis axis) {
        this.dir = new Vector3i(x, y, z);
        this.axis = axis;
        this.opposite = null;
    }

    public Vector3i toVector() {
        return this.dir;
    }

    public static Direction fromString(String name) {
        Objects.requireNonNull(name);
        return Direction.valueOf(name.toUpperCase());
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Direction getOpposite() {
        return this.opposite;
    }

    public Direction getLeft() {
        return this.left;
    }

    public Direction getRight() {
        return this.right;
    }

    public Direction getLocalUp() {
        return this.localUp;
    }

    static {
        Direction.UP.opposite = DOWN;
        Direction.DOWN.opposite = UP;
        Direction.NORTH.opposite = SOUTH;
        Direction.SOUTH.opposite = NORTH;
        Direction.WEST.opposite = EAST;
        Direction.EAST.opposite = WEST;
        Direction.UP.left = UP;
        Direction.DOWN.left = DOWN;
        Direction.NORTH.left = WEST;
        Direction.SOUTH.left = EAST;
        Direction.WEST.left = SOUTH;
        Direction.EAST.left = NORTH;
        Direction.UP.right = UP;
        Direction.DOWN.right = DOWN;
        Direction.NORTH.right = EAST;
        Direction.SOUTH.right = WEST;
        Direction.WEST.right = NORTH;
        Direction.EAST.right = SOUTH;
        Direction.UP.localUp = NORTH;
        Direction.DOWN.localUp = SOUTH;
        Direction.NORTH.localUp = UP;
        Direction.SOUTH.localUp = UP;
        Direction.WEST.localUp = UP;
        Direction.EAST.localUp = UP;
    }
}

