/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public enum Tristate {
    TRUE(true){

        @Override
        public Tristate and(Supplier<Tristate> other) {
            return other.get();
        }

        @Override
        public Tristate or(Supplier<Tristate> other) {
            return this;
        }
    }
    ,
    UNDEFINED(false){

        @Override
        public Tristate getOr(Tristate other) {
            return other;
        }

        @Override
        public boolean getOr(BooleanSupplier other) {
            return other.getAsBoolean();
        }

        @Override
        public boolean getOr(boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public Tristate and(Supplier<Tristate> other) {
            return other.get() == FALSE ? FALSE : this;
        }

        @Override
        public Tristate or(Supplier<Tristate> other) {
            return other.get() == TRUE ? TRUE : this;
        }
    }
    ,
    FALSE(false){

        @Override
        public Tristate and(Supplier<Tristate> other) {
            return this;
        }

        @Override
        public Tristate or(Supplier<Tristate> other) {
            return other.get();
        }
    };

    private final boolean value;
    private Tristate negative;

    public Tristate getOr(Tristate other) {
        return this;
    }

    public boolean getOr(BooleanSupplier other) {
        return this.value;
    }

    public boolean getOr(boolean defaultValue) {
        return this.value;
    }

    public Tristate negated() {
        return this.negative;
    }

    public abstract Tristate and(Supplier<Tristate> var1);

    public abstract Tristate or(Supplier<Tristate> var1);

    public Tristate and(Tristate other) {
        return this.and(() -> other);
    }

    public Tristate or(Tristate other) {
        return this.or(() -> other);
    }

    public String toString() {
        return "Tristate." + this.name();
    }

    public static Tristate valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    private Tristate(boolean value) {
        this.value = value;
    }

    static {
        Tristate.TRUE.negative = FALSE;
        Tristate.UNDEFINED.negative = UNDEFINED;
        Tristate.FALSE.negative = TRUE;
    }
}

