/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util.math;

public class Color {
    public float r;
    public float g;
    public float b;
    public float a;
    public boolean premultiplied;

    public Color set(float r, float g2, float b, float a, boolean premultiplied) {
        this.r = r;
        this.g = g2;
        this.b = b;
        this.a = a;
        this.premultiplied = premultiplied;
        return this;
    }

    public Color set(Color color) {
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        this.premultiplied = color.premultiplied;
        return this;
    }

    public Color set(int color) {
        return this.set(color, false);
    }

    public Color set(int color, boolean premultiplied) {
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
        this.a = (float)(color >> 24 & 0xFF) / 255.0f;
        this.premultiplied = premultiplied;
        return this;
    }

    public int getInt() {
        int r = (int)(this.r * 255.0f) & 0xFF;
        int g2 = (int)(this.g * 255.0f) & 0xFF;
        int b = (int)(this.b * 255.0f) & 0xFF;
        int a = (int)(this.a * 255.0f) & 0xFF;
        return a << 24 | r << 16 | g2 << 8 | b;
    }

    public Color add(Color color) {
        if (color.a < 1.0f && !color.premultiplied) {
            throw new IllegalArgumentException("Can only add premultiplied colors with alpha!");
        }
        this.premultiplied();
        this.r += color.r;
        this.g += color.g;
        this.b += color.b;
        this.a += color.a;
        return this;
    }

    public Color div(int divisor) {
        this.premultiplied();
        float p = 1.0f / (float)divisor;
        this.r *= p;
        this.g *= p;
        this.b *= p;
        this.a *= p;
        return this;
    }

    public Color multiply(Color color) {
        if (color.premultiplied) {
            this.premultiplied();
        } else {
            this.straight();
        }
        this.r *= color.r;
        this.g *= color.g;
        this.b *= color.b;
        this.a *= color.a;
        return this;
    }

    public Color overlay(Color color) {
        if (color.a < 1.0f && !color.premultiplied) {
            throw new IllegalArgumentException("Can only overlay premultiplied colors with alpha!");
        }
        this.premultiplied();
        float p = 1.0f - color.a;
        this.a = p * this.a + color.a;
        this.r = p * this.r + color.r;
        this.g = p * this.g + color.g;
        this.b = p * this.b + color.b;
        return this;
    }

    public Color underlay(Color color) {
        if (color.a < 1.0f && !color.premultiplied) {
            throw new IllegalArgumentException("Can only underlay premultiplied colors with alpha!");
        }
        this.premultiplied();
        float p = 1.0f - this.a;
        this.a = p * color.a + this.a;
        this.r = p * color.r + this.r;
        this.g = p * color.g + this.g;
        this.b = p * color.b + this.b;
        return this;
    }

    public Color flatten() {
        if (this.a == 1.0f) {
            return this;
        }
        if (this.premultiplied && this.a > 0.0f) {
            float m4 = 1.0f / this.a;
            this.r *= m4;
            this.g *= m4;
            this.b *= m4;
        }
        this.a = 1.0f;
        return this;
    }

    public Color premultiplied() {
        if (!this.premultiplied) {
            this.r *= this.a;
            this.g *= this.a;
            this.b *= this.a;
            this.premultiplied = true;
        }
        return this;
    }

    public Color straight() {
        if (this.premultiplied) {
            if (this.a > 0.0f) {
                float m4 = 1.0f / this.a;
                this.r *= m4;
                this.g *= m4;
                this.b *= m4;
            }
            this.premultiplied = false;
        }
        return this;
    }

    public Color parse(String value) {
        Object val = value;
        if (((String)val).charAt(0) == '#') {
            if (((String)(val = ((String)val).substring(1))).length() == 3) {
                val = (String)val + "f";
            }
            if (((String)val).length() == 4) {
                val = "" + ((String)val).charAt(0) + ((String)val).charAt(0) + ((String)val).charAt(1) + ((String)val).charAt(1) + ((String)val).charAt(2) + ((String)val).charAt(2) + ((String)val).charAt(3) + ((String)val).charAt(3);
            }
            if (((String)val).length() == 6) {
                val = (String)val + "ff";
            }
            if (((String)val).length() != 8) {
                throw new NumberFormatException("Invalid color format: '" + value + "'!");
            }
            val = ((String)val).substring(6, 8) + ((String)val).substring(0, 6);
            return this.set(Integer.parseUnsignedInt((String)val, 16));
        }
        int color = Integer.parseInt((String)val);
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        return this.set(color);
    }

    public String toString() {
        return "Color{r=" + this.r + " (" + (int)(this.r * 255.0f) + "), g=" + this.g + " (" + (int)(this.g * 255.0f) + "), b=" + this.b + " (" + (int)(this.b * 255.0f) + "), a=" + this.a + " (" + (int)(this.a * 255.0f) + "), premultiplied=" + this.premultiplied + "}";
    }
}

