/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BlockState {
    private static final Pattern BLOCKSTATE_SERIALIZATION_PATTERN = Pattern.compile("^(.+?)(?:\\[(.*)])?$");
    private static final Key MISSING_ID = Key.bluemap("missing");
    private static final Key AIR_ID = Key.minecraft("air");
    private static final Key CAVE_AIR_ID = Key.minecraft("cave_air");
    private static final Key VOID_AIR_ID = Key.minecraft("void_air");
    private static final Key WATER_ID = Key.minecraft("water");
    public static final BlockState AIR = new BlockState(AIR_ID);
    public static final BlockState MISSING = new BlockState(MISSING_ID);
    public static final BlockState WATER = new BlockState(WATER_ID);
    private boolean hashed;
    private int hash;
    private final Key id;
    private final Map<String, String> properties;
    private final Property[] propertiesArray;
    private final boolean isAir;
    private final boolean isWater;
    private final boolean isWaterlogged;
    private int liquidLevel = -1;
    private int redstonePower = -1;

    public BlockState(Key id) {
        this(id, Collections.emptyMap());
    }

    public BlockState(Key id, Map<String, String> properties) {
        this.id = id;
        this.hashed = false;
        this.hash = 0;
        this.properties = properties;
        this.propertiesArray = (Property[])properties.entrySet().stream().map(e -> new Property((String)e.getKey(), (String)e.getValue())).sorted().toArray(Property[]::new);
        this.isAir = AIR_ID.equals(this.id) || CAVE_AIR_ID.equals(this.id) || VOID_AIR_ID.equals(this.id);
        this.isWater = WATER_ID.equals(this.id);
        this.isWaterlogged = "true".equals(properties.get("waterlogged"));
    }

    public Key getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isWater() {
        return this.isWater;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public int getLiquidLevel() {
        if (this.liquidLevel == -1) {
            try {
                String levelString = this.properties.get("level");
                int n = this.liquidLevel = levelString != null ? Integer.parseInt(levelString) : 0;
                if (this.liquidLevel > 15) {
                    this.liquidLevel = 15;
                }
                if (this.liquidLevel < 0) {
                    this.liquidLevel = 0;
                }
            }
            catch (NumberFormatException ex) {
                this.liquidLevel = 0;
            }
        }
        return this.liquidLevel;
    }

    public int getRedstonePower() {
        if (this.redstonePower == -1) {
            try {
                String levelString = this.properties.get("power");
                int n = this.redstonePower = levelString != null ? Integer.parseInt(levelString) : 0;
                if (this.redstonePower > 15) {
                    this.redstonePower = 15;
                }
                if (this.redstonePower < 0) {
                    this.redstonePower = 0;
                }
            }
            catch (NumberFormatException ex) {
                this.redstonePower = 15;
            }
        }
        return this.redstonePower;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockState)) {
            return false;
        }
        BlockState b = (BlockState)obj;
        if (!this.id.equals(b.id)) {
            return false;
        }
        return Arrays.equals(this.propertiesArray, b.propertiesArray);
    }

    public int hashCode() {
        if (!this.hashed) {
            this.hash = Objects.hash(this.id, this.properties);
            this.hashed = true;
        }
        return this.hash;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            sj.add(e.getKey() + "=" + e.getValue());
        }
        return this.id.getFormatted() + "[" + String.valueOf(sj) + "]";
    }

    public static BlockState fromString(String serializedBlockState) throws IllegalArgumentException {
        try {
            Matcher m4 = BLOCKSTATE_SERIALIZATION_PATTERN.matcher(serializedBlockState);
            if (!m4.find()) {
                throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
            }
            HashMap<String, String> pt = new HashMap<String, String>();
            String g2 = m4.group(2);
            if (g2 != null && !g2.isEmpty()) {
                String[] propertyStrings;
                for (String s2 : propertyStrings = g2.trim().split(",")) {
                    String[] kv = s2.split("=", 2);
                    pt.put(kv[0], kv[1]);
                }
            }
            String blockId = m4.group(1).trim();
            return new BlockState(Key.parse(blockId), pt);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
        }
    }

    public static final class Property
    implements Comparable<Property> {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            this.key = StringUtil.intern(key);
            this.value = StringUtil.intern(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return this.key == property.key && this.value == property.value;
        }

        public int hashCode() {
            return this.key.hashCode() * 31 ^ this.value.hashCode();
        }

        @Override
        public int compareTo(@NotNull Property o) {
            int keyCompare = this.key.compareTo(o.key);
            return keyCompare != 0 ? keyCompare : this.value.compareTo(o.value);
        }
    }
}

