/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.region;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;

public class MCARegion<T>
implements Region<T> {
    public static final String FILE_SUFFIX = ".mca";
    public static final Pattern FILE_PATTERN = Pattern.compile("^r\\.(-?\\d+)\\.(-?\\d+)\\.mca$");
    public static final Compression[] CHUNK_COMPRESSION_MAP = new Compression[255];
    private final Path regionFile;
    private final ChunkLoader<T> chunkLoader;
    private final Vector2i regionPos;

    public MCARegion(ChunkLoader<T> chunkLoader, Path regionFile) throws IllegalArgumentException {
        this.chunkLoader = chunkLoader;
        this.regionFile = regionFile;
        String[] filenameParts = regionFile.getFileName().toString().split("\\.");
        int rX = Integer.parseInt(filenameParts[1]);
        int rZ = Integer.parseInt(filenameParts[2]);
        this.regionPos = new Vector2i(rX, rZ);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T loadChunk(int chunkX, int chunkZ) throws IOException {
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return this.chunkLoader.emptyChunk();
        }
        long fileLength = Files.size(this.regionFile);
        if (fileLength == 0L) {
            return this.chunkLoader.emptyChunk();
        }
        try (FileChannel channel = FileChannel.open(this.regionFile, StandardOpenOption.READ);){
            int xzChunk = (chunkZ & 0x1F) << 5 | chunkX & 0x1F;
            byte[] header = new byte[4];
            channel.position(xzChunk * 4);
            MCARegion.readFully((ReadableByteChannel)channel, header, 0, 4);
            long offset = (header[0] & 0xFF) << 16;
            offset |= (long)((header[1] & 0xFF) << 8);
            offset |= (long)(header[2] & 0xFF);
            offset *= 4096L;
            int size = (header[3] & 0xFF) * 4096;
            if (size <= 0) {
                T t2 = this.chunkLoader.emptyChunk();
                return t2;
            }
            byte[] chunkDataBuffer = new byte[size];
            channel.position(offset);
            MCARegion.readFully((ReadableByteChannel)channel, chunkDataBuffer, 0, size);
            T t3 = this.loadChunk(chunkDataBuffer, size);
            return t3;
        }
        catch (IOException | RuntimeException ex) {
            throw new IOException("Exception trying to read chunk (%d,%d) from region '%s'".formatted(chunkX, chunkZ, this.regionFile), ex);
        }
    }

    @Override
    public void iterateAllChunks(ChunkConsumer<T> consumer) throws IOException {
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return;
        }
        long fileLength = Files.size(this.regionFile);
        if (fileLength == 0L) {
            return;
        }
        int chunkStartX = this.regionPos.getX() * 32;
        int chunkStartZ = this.regionPos.getY() * 32;
        try (FileChannel channel = FileChannel.open(this.regionFile, StandardOpenOption.READ);){
            byte[] header = new byte[8192];
            byte[] chunkDataBuffer = null;
            MCARegion.readFully((ReadableByteChannel)channel, header, 0, header.length);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    int xzChunk = (z & 0x1F) << 5 | x & 0x1F;
                    int size = (header[xzChunk * 4 + 3] & 0xFF) * 4096;
                    if (size <= 0) continue;
                    int chunkX = chunkStartX + x;
                    int chunkZ = chunkStartZ + z;
                    int i = xzChunk * 4 + 4096;
                    int timestamp = header[i++] << 24;
                    timestamp |= (header[i++] & 0xFF) << 16;
                    timestamp |= (header[i++] & 0xFF) << 8;
                    if (!consumer.filter(chunkX, chunkZ, timestamp |= header[i] & 0xFF)) continue;
                    i = xzChunk * 4;
                    long offset = (header[i++] & 0xFF) << 16;
                    offset |= (long)((header[i++] & 0xFF) << 8);
                    offset |= (long)(header[i] & 0xFF);
                    offset *= 4096L;
                    if (chunkDataBuffer == null || chunkDataBuffer.length < size) {
                        chunkDataBuffer = new byte[size];
                    }
                    channel.position(offset);
                    MCARegion.readFully((ReadableByteChannel)channel, chunkDataBuffer, 0, size);
                    try {
                        T chunk = this.loadChunk(chunkDataBuffer, size);
                        consumer.accept(chunkX, chunkZ, chunk);
                        continue;
                    }
                    catch (IOException ex) {
                        consumer.fail(chunkX, chunkZ, ex);
                        continue;
                    }
                    catch (Exception ex) {
                        consumer.fail(chunkX, chunkZ, new IOException(ex));
                    }
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            throw new IOException("Exception trying to iterate chunks in region '%s'".formatted(this.regionFile), ex);
        }
    }

    @Override
    public T emptyChunk() {
        return this.chunkLoader.emptyChunk();
    }

    private T loadChunk(byte[] data, int size) throws IOException {
        int compressionTypeId = Byte.toUnsignedInt(data[4]);
        Compression compression = CHUNK_COMPRESSION_MAP[compressionTypeId];
        if (compression == null) {
            throw new IOException("Unknown chunk compression-id: " + compressionTypeId);
        }
        return this.chunkLoader.load(data, 5, size - 5, compression);
    }

    public static String getRegionFileName(int regionX, int regionZ) {
        return "r." + regionX + "." + regionZ + FILE_SUFFIX;
    }

    private static void readFully(ReadableByteChannel src, byte[] dst, int off, int len) throws IOException {
        MCARegion.readFully(src, ByteBuffer.wrap(dst), off, len);
    }

    private static void readFully(ReadableByteChannel src, ByteBuffer bb, int off, int len) throws IOException {
        int limit = off + len;
        if (limit > bb.capacity()) {
            throw new IllegalArgumentException("buffer too small");
        }
        bb.limit(limit);
        bb.position(off);
        do {
            int read;
            if ((read = src.read(bb)) >= 0) continue;
            while (bb.remaining() > 0) {
                bb.put((byte)0);
            }
        } while (bb.remaining() > 0);
    }

    public Path getRegionFile() {
        return this.regionFile;
    }

    public ChunkLoader<T> getChunkLoader() {
        return this.chunkLoader;
    }

    public Vector2i getRegionPos() {
        return this.regionPos;
    }

    static {
        MCARegion.CHUNK_COMPRESSION_MAP[0] = Compression.NONE;
        MCARegion.CHUNK_COMPRESSION_MAP[1] = Compression.GZIP;
        MCARegion.CHUNK_COMPRESSION_MAP[2] = Compression.DEFLATE;
        MCARegion.CHUNK_COMPRESSION_MAP[3] = Compression.NONE;
        MCARegion.CHUNK_COMPRESSION_MAP[4] = Compression.LZ4;
    }
}

