/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import com.flowpowered.math.vector.Vector3d;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.forge.ForgeMod;
import de.bluecolored.shadow.adventure.adventure.text.TextComponent;
import de.bluecolored.shadow.adventure.adventure.text.serializer.gson.GsonComponentSerializer;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.phys.Vec3;

public class ForgeCommandSource
implements CommandSource {
    private final ForgeMod mod;
    private final CommandSourceStack delegate;

    public ForgeCommandSource(ForgeMod mod, CommandSourceStack delegate) {
        this.mod = mod;
        this.delegate = delegate;
    }

    @Override
    public void sendMessage(de.bluecolored.shadow.adventure.adventure.text.Component text) {
        if (TextFormat.lineCount(text) > 1) {
            text = ((TextComponent)de.bluecolored.shadow.adventure.adventure.text.Component.newline().append(text)).appendNewline();
        }
        JsonElement textJson = GsonComponentSerializer.gson().serializeToTree(text.compact());
        Component minecraftText = (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)textJson).getOrThrow();
        this.delegate.sendSystemMessage(minecraftText);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.delegate.hasPermission(1);
    }

    @Override
    public Optional<Vector3d> getPosition() {
        if (!this.delegate.isPlayer() && this.delegate.getTextName().equals("Server")) {
            return Optional.empty();
        }
        Vec3 pos = this.delegate.getPosition();
        return Optional.of(new Vector3d(pos.x, pos.y, pos.z));
    }

    @Override
    public Optional<ServerWorld> getWorld() {
        if (!this.delegate.isPlayer() && this.delegate.getTextName().equals("Server")) {
            return Optional.empty();
        }
        return Optional.of(this.delegate.getLevel()).map(this.mod::getServerWorld);
    }
}

