/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.apache.commons.dbcp2;

import de.bluecolored.shadow.apache.commons.dbcp2.LifetimeExceededException;
import de.bluecolored.shadow.apache.commons.dbcp2.Utils;
import de.bluecolored.shadow.apache.commons.logging.Log;
import de.bluecolored.shadow.apache.commons.pool2.SwallowedExceptionListener;

public class SwallowedExceptionLogger
implements SwallowedExceptionListener {
    private final Log log;
    private final boolean logExpiredConnections;

    public SwallowedExceptionLogger(Log log) {
        this(log, true);
    }

    public SwallowedExceptionLogger(Log log, boolean logExpiredConnections) {
        this.log = log;
        this.logExpiredConnections = logExpiredConnections;
    }

    @Override
    public void onSwallowException(Exception e) {
        if (this.logExpiredConnections || !(e instanceof LifetimeExceededException)) {
            this.log.warn(Utils.getMessage("swallowedExceptionLogger.onSwallowedException"), e);
        }
    }
}

