/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration;

import biomesoplenty.api.biome.BOPBiome;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.common.biome.decoration.BOPOverworldBiomeDecorator;
import biomesoplenty.common.biome.decoration.OverworldBiomeFeatures;
import biomesoplenty.common.blocks.BlockBOPFoliage;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import com.vladmarica.bopIntegration.Config;
import com.vladmarica.bopIntegration.hee.TowerGlowstoneReplacer;
import com.vladmarica.bopIntegration.ic2.IC2CompatWorldGenerator;
import com.vladmarica.bopIntegration.thaumcraft.ThaumcraftModCompat;
import com.vladmarica.bopIntegration.tweaks.BOPLegacyWorldGenerator;
import com.vladmarica.bopIntegration.tweaks.BlockBOPBerryBush;
import com.vladmarica.bopIntegration.tweaks.event.EventBerryPlanting;
import com.vladmarica.bopIntegration.tweaks.world.WorldGenBerryBush;
import com.vladmarica.bopIntegration.tweaks.world.WorldGenNothing;
import com.vladmarica.bopIntegration.tweaks.world.WorldGenWaspHiveFixed;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="BOPIntegrations", name="BOPIntegrations", version="1.6.0-Catized", dependencies="required-after:BiomesOPlenty", acceptedMinecraftVersions="[1.7.10]")
public class BOPIntegrationMod {
    public static final Logger logger = LogManager.getLogger((String)"BOPIntegrations");
    public static Config config;
    public static Block bopBerryBush;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Config(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (BOPIntegrationMod.config.growableBopBerry) {
            EventBerryPlanting.register();
            bopBerryBush = new BlockBOPBerryBush();
            GameRegistry.registerBlock((Block)bopBerryBush, (String)"berry_bush");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (BOPIntegrationMod.config.waspHiveRarityModifier > 0.0f) {
            WorldGenFieldAssociation.associateFeature((String)"waspHivesPerChunk", (WorldGenerator)new WorldGenWaspHiveFixed());
        }
        if (BOPIntegrationMod.config.removeNetherGravestones) {
            WorldGenFieldAssociation.associateFeature((String)"gravesPerChunk", (WorldGenerator)new WorldGenNothing());
        }
        if (BOPIntegrationMod.config.disableBopOriginalBerryBush) {
            WorldGenFieldAssociation.associateFeature((String)"berryBushesPerChunk", (WorldGenerator)new WorldGenNothing());
        }
        if (BOPIntegrationMod.config.growableBopBerry) {
            WorldGenFieldAssociation.associateFeature((String)"berryBushesPerChunk", (WorldGenerator)new WorldGenBerryBush(bopBerryBush, 0));
        }
        if (BOPIntegrationMod.config.craftableRottenFlesh) {
            Item rottenFleshItem;
            block34: {
                try {
                    Field rottenFleshField = Items.class.getDeclaredField("rotten_flesh");
                    rottenFleshItem = (Item)rottenFleshField.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    rottenFleshItem = (Item)Item.itemRegistry.getObject("rotten_flesh");
                    if (rottenFleshItem != null) break block34;
                    logger.error("Failed to get rotten flesh item!");
                    return;
                }
            }
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(rottenFleshItem, 4), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), new ItemStack(BOPCItems.misc, 1, 3), Character.valueOf('X'), new ItemStack(BOPCBlocks.flowers, 1, 13)});
        }
        if (BOPIntegrationMod.config.removeEnderporterRecipe) {
            ItemStack enderporter = new ItemStack(BOPCItems.enderporter, 1);
            if (BOPIntegrationMod.removeRecipe(enderporter)) {
                logger.info("Removed Enderporter recipe");
            } else {
                logger.error("Failed to remove Enderporter recipe!");
            }
        }
        if (BOPIntegrationMod.config.harderBiomeFinderRecipe) {
            ItemStack biomeFinder = new ItemStack(BOPCItems.biomeFinder, 1);
            if (BOPIntegrationMod.removeRecipe(biomeFinder)) {
                Item emeraldItem;
                Item crystalItem;
                block35: {
                    crystalItem = null;
                    try {
                        Field emeraldField = Items.class.getDeclaredField("emerald");
                        emeraldItem = (Item)emeraldField.get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        emeraldItem = (Item)Item.itemRegistry.getObject("emerald");
                        if (emeraldItem != null) break block35;
                        emeraldItem = (Item)Item.itemRegistry.getObject("minecraft:emerald");
                    }
                }
                try {
                    crystalItem = (Item)Item.itemRegistry.getObject("BiomesOPlenty:crystal");
                }
                catch (Exception e) {
                    logger.error("Failed to get crystal item");
                }
                if (emeraldItem != null && crystalItem != null) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BOPCItems.biomeFinder, 1), (Object[])new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), new ItemStack(emeraldItem, 1), Character.valueOf('X'), new ItemStack(crystalItem, 1), Character.valueOf('Y'), new ItemStack(BOPCItems.misc, 1, 10)});
                } else {
                    logger.error("Failed to add harder Biome Finder recipe - missing items");
                }
            } else {
                logger.error("Failed to remove Biome Finder recipe!");
            }
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftModCompat.apply();
        } else {
            logger.info("Thaumcraft not found - skipping integration patch");
        }
        if (BOPIntegrationMod.config.koruFrequencyMultiplier >= 0) {
            this.increaseKoruFrequency();
        }
        if (BOPIntegrationMod.config.fixIC2RubberTrees) {
            if (Loader.isModLoaded((String)"IC2")) {
                GameRegistry.registerWorldGenerator((IWorldGenerator)new IC2CompatWorldGenerator(), (int)10);
                logger.info("IC2 rubber tree fix applied");
            } else {
                logger.error("IC2 not found - skipping rubber tree fix");
            }
        } else if (Loader.isModLoaded((String)"IC2")) {
            logger.info("IC2 is Installed, while the config fixIC2RubberTrees is disabled. Will not fix the rubber tree.");
        } else {
            logger.info("Neither IC2 is installed, nor the config enabled, will do nothing.");
        }
        if (BOPIntegrationMod.config.replaceGlowStoneInTower) {
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TowerGlowstoneReplacer());
                logger.info("Found HEE in mod list, the config replaceGlowStoneInTower is enabled, applying it into the game instance");
            } else {
                logger.info("HEE Not Found in mod list, though the config replaceGlowStoneInTower is enabled, skipping it.");
            }
        } else if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
            logger.info("Found HEE in mod list, while the config replaceGlowStoneInTower is enabled, skipping it.");
        } else {
            logger.info("Neither HEE is installed, nor the co nfig enabled, will do nothing.");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BOPLegacyWorldGenerator(), (int)0);
        this.cakeCleanup();
    }

    public static boolean unregisterWorldGenerator(IWorldGenerator worldGenerator) {
        try {
            Field worldGeneratorsField = GameRegistry.class.getDeclaredField("worldGenerators");
            worldGeneratorsField.setAccessible(true);
            Field worldGeneratorIndexField = GameRegistry.class.getDeclaredField("worldGeneratorIndex");
            worldGeneratorIndexField.setAccessible(true);
            Set generators = (Set)worldGeneratorsField.get(worldGenerator);
            Map generatorIndexMap = (Map)worldGeneratorIndexField.get(worldGenerator);
            if (!generators.contains(worldGenerator)) {
                return false;
            }
            generators.remove(worldGenerator);
            generatorIndexMap.remove(worldGenerator);
            return true;
        }
        catch (Exception ex) {
            logger.error("Failed to unregister world generator:" + worldGenerator + ". Returned:" + ex);
            return false;
        }
    }

    public static boolean removeRecipe(ItemStack output) {
        if (output == null) {
            return false;
        }
        try {
            Field instanceField = CraftingManager.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            CraftingManager craftingManager = (CraftingManager)instanceField.get(null);
            List recipes = craftingManager.getRecipeList();
            boolean removed = false;
            for (int i = 0; i < recipes.size(); ++i) {
                ItemStack recipeOutput;
                IRecipe recipe = (IRecipe)recipes.get(i);
                if (recipe == null || (recipeOutput = recipe.getRecipeOutput()) == null) continue;
                ItemStack compareOutput = output.copy();
                compareOutput.stackSize = 1;
                recipeOutput = recipeOutput.copy();
                recipeOutput.stackSize = 1;
                if (!ItemStack.areItemStacksEqual((ItemStack)compareOutput, (ItemStack)recipeOutput)) continue;
                recipes.remove(i--);
                removed = true;
                logger.info("Removed recipe for: " + output.getDisplayName());
            }
            return removed;
        }
        catch (Exception ex) {
            logger.error("Error removing recipe for " + output.getDisplayName() + ": ", (Throwable)ex);
            return false;
        }
    }

    private static List<IRecipe> getIRecipes(ItemStack output, CraftingManager craftingManager) {
        ArrayList<IRecipe> recipesToRemove = new ArrayList<IRecipe>();
        for (Object obj : craftingManager.getRecipeList()) {
            IRecipe recipe;
            ItemStack thisOutput;
            if (!(obj instanceof IRecipe) || (thisOutput = (recipe = (IRecipe)obj).getRecipeOutput()) == null || thisOutput.getItem() != output.getItem() || thisOutput.getItemDamage() != output.getItemDamage()) continue;
            recipesToRemove.add(recipe);
        }
        return recipesToRemove;
    }

    private void increaseKoruFrequency() {
        try {
            Field[] biomeFields;
            int multiplier;
            int n = multiplier = config == null ? 8 : BOPIntegrationMod.config.koruFrequencyMultiplier;
            if (multiplier < 0) {
                multiplier = 0;
            }
            int modifiedCount = 0;
            for (Field biomeField : biomeFields = BOPCBiomes.class.getDeclaredFields()) {
                Object decoratorObj;
                BOPBiome biome;
                Object obj = biomeField.get(null);
                if (!(obj instanceof BOPBiome) || (biome = (BOPBiome)obj) == null) continue;
                try {
                    decoratorObj = biome.getClass().getField("theBiomeDecorator").get(biome);
                }
                catch (Throwable ignored1) {
                    decoratorObj = biome.getClass().getField("field_76760_I").get(biome);
                }
                if (!(decoratorObj instanceof BOPOverworldBiomeDecorator)) continue;
                BOPOverworldBiomeDecorator decorator = (BOPOverworldBiomeDecorator)decoratorObj;
                OverworldBiomeFeatures features = (OverworldBiomeFeatures)decorator.bopFeatures;
                if (features == null) continue;
                if (multiplier == 0) {
                    if (features.koruPerChunk == 0) continue;
                    features.koruPerChunk = 0;
                    ++modifiedCount;
                    continue;
                }
                long newVal = (long)features.koruPerChunk * (long)multiplier;
                int capped = (int)Math.min(newVal, 0x3FFFFFFFL);
                if (features.koruPerChunk == capped) continue;
                features.koruPerChunk = capped;
                ++modifiedCount;
            }
            logger.info("Adjusted Koru frequency with multiplier={} for {} biomes", new Object[]{multiplier, modifiedCount});
        }
        catch (Exception ex) {
            logger.warn("Failed to modify Koru frequency", (Throwable)ex);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.block.getClass() == BlockBOPFoliage.class && event.blockMetadata == 12) {
            event.drops.clear();
            event.dropChance = 1.0f;
            event.drops.add(new ItemStack(BOPCItems.turnipSeeds, 1));
        }
    }

    private void cakeCleanup() {
        try {
            Field handlersField = EventBus.class.getDeclaredField("listeners");
            handlersField.setAccessible(true);
            ConcurrentHashMap listeners = (ConcurrentHashMap)handlersField.get(FMLCommonHandler.instance().bus());
            for (Object o : listeners.keySet()) {
                if (!o.getClass().getSimpleName().equals("EventHandlerCake")) continue;
                FMLCommonHandler.instance().bus().unregister(o);
                logger.info("Unregistered cake crafting handler");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

