/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private Configuration configurationFile;
    public boolean genCelestialCrystals;
    public boolean genBiomeEssence;
    public boolean removeNetherGravestones;
    public boolean craftableRottenFlesh;
    public boolean removeEnderporterRecipe;
    public boolean harderBiomeFinderRecipe;
    public float waspHiveRarityModifier;
    public int koruFrequencyMultiplier;
    public boolean fixSilverwoodTrees;
    public boolean addMissingAspects;
    public boolean fixIC2RubberTrees;
    public boolean amethystEndGen;
    public boolean genAmethystOreOverworld;
    public boolean replaceGlowStoneInTower;
    public boolean growableBopBerry;
    public boolean disableBopOriginalBerryBush;
    public boolean berryWorldGen;
    public int berryClusterSize;

    public Config(File file) {
        this.configurationFile = new Configuration(file);
        this.configurationFile.addCustomCategoryComment("Tweaks", "These options modify BOP itself. Some of these features are unavailable in the 1.7.10 version of BOP but existed in previous or later versions.");
        this.configurationFile.addCustomCategoryComment("Thaumcraft", "Options to make BOP work better with Thaumcraft");
        this.configurationFile.addCustomCategoryComment("HardCoreEnderExpansion", "Expand HEE's Feature with BOP");
        this.configurationFile.addCustomCategoryComment("IC2", "Options to make BOP work better with IC2");
        this.configurationFile.load();
        this.BopIntegrateOptions();
        this.saveConfigurationFile();
    }

    public void BopIntegrateOptions() {
        this.genCelestialCrystals = this.configurationFile.getBoolean("genCelestialCrystals", "Tweaks", true, "Generate Celestial Crystals in the End. Used to make Ambrosia.");
        this.genBiomeEssence = this.configurationFile.getBoolean("genBiomeEssence", "Tweaks", true, "Generate Biome Essence Ore in the End. Drops Biome Essence.");
        this.removeNetherGravestones = this.configurationFile.getBoolean("removeNetherGravestones", "Tweaks", true, "Prevent gravestones from spawning in the Nether. They are ugly and useless.");
        this.craftableRottenFlesh = this.configurationFile.getBoolean("craftableRottenFlesh", "Tweaks", false, "Adds a recipe to craft rotten flesh out of flesh chunks and an eyebulb.");
        this.removeEnderporterRecipe = this.configurationFile.getBoolean("removeEnderporterRecipe", "Tweaks", false, "It can still be cheating in by an op.");
        this.harderBiomeFinderRecipe = this.configurationFile.getBoolean("harderBiomeFinderRecipe", "Tweaks", false, "Makes the recipe use end crystals and ghastly souls.");
        this.waspHiveRarityModifier = this.configurationFile.getFloat("waspHiveRarityModifier", "Tweaks", 1.0f, 0.0f, 1.0f, "You can use this option to make nether wasp hives rarer.");
        this.fixSilverwoodTrees = this.configurationFile.getBoolean("fixSilverwoodTrees", "Thaumcraft", false, "Allows Silverwood trees to spawn in all forest and plains biomes.");
        this.addMissingAspects = this.configurationFile.getBoolean("addMissingAspects", "Thaumcraft", true, "Many BOP items don't give any aspects. ");
        this.fixIC2RubberTrees = this.configurationFile.getBoolean("fixRubberTrees", "IC2", false, "Fix rubber trees incorrecting spawning in grassland and marsh biomes.");
        this.koruFrequencyMultiplier = this.configurationFile.getInt("koruFrequencyMultiplier", "Tweaks", 1, 0, 128, "Multiplier for Koru generation frequency. Set to 0 to disable Koru entirely.");
        this.amethystEndGen = this.configurationFile.getBoolean("amethystEndGen", "Tweaks", false, "The Ender Amethyst ore is able to generate in the end now.");
        this.genAmethystOreOverworld = this.configurationFile.getBoolean("genAmethystOreOverworld", "Tweaks", true, "Set false to disable it generated in the overworld");
        this.replaceGlowStoneInTower = this.configurationFile.getBoolean("replaceGlowStoneInTower", "HardcoreEnderExpansion", false, "Replace the Glow Stone as Celestial Crystals ");
        this.growableBopBerry = this.configurationFile.getBoolean("growableBopBerry", "Tweaks", false, "Enable the berry bush planting and growing feature.");
        this.disableBopOriginalBerryBush = this.configurationFile.getBoolean("disableBopOriginalBerryBush", "Tweaks", false, "Disable the original Berry Bush of Biomes O' Plenty generate in the world");
        this.berryClusterSize = this.configurationFile.getInt("berryClusterSize", "Tweaks", 8, 0, 64, "Berry Bushes per chunk");
    }

    public void saveConfigurationFile() {
        this.configurationFile.save();
    }

    public boolean hasChanged() {
        return this.configurationFile.hasChanged();
    }
}

