/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.tweaks;

import biomesoplenty.BiomesOPlenty;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockBOPBerryBush
extends BlockBush
implements IGrowable {
    private static final boolean DEBUG_LOG = false;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons = new IIcon[4];

    public BlockBOPBerryBush() {
        super(BlockBOPBerryBush.getMaterialPlants());
        this.setHardness(0.0f);
        this.setStepSound(soundTypeGrass);
        this.setTickRandomly(true);
        this.setBlockName("bopBerryBush");
        this.setCreativeTab(BiomesOPlenty.tabBiomesOPlenty);
        this.setBlockTextureName("bopintegration:berry_bush_stage0");
    }

    private static Material getMaterialPlants() {
        String[] names;
        Class<Material> cls = Material.class;
        for (String name : names = new String[]{"field_151585_k", "plants", "PLANTS", "PLANT"}) {
            try {
                Field f = cls.getDeclaredField(name);
                f.setAccessible(true);
                Object value = f.get(null);
                if (!(value instanceof Material)) continue;
                return (Material)value;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Material.vine;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        Block soil = world.getBlock(x, y - 1, z);
        boolean ok = soil == Blocks.grass || soil == Blocks.dirt || soil == Blocks.farmland;
        return ok;
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.grass || block == Blocks.dirt || block == Blocks.farmland;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        Block b = world.getBlock(x, y, z);
        if (world.isAirBlock(x, y, z)) {
            return true;
        }
        if (b == Blocks.tallgrass || b == Blocks.deadbush) {
            return true;
        }
        return super.canPlaceBlockAt(world, x, y, z);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3) {
            if (!world.isRemote) {
                Item berryItem = (Item)Item.itemRegistry.getObject("BiomesOPlenty:food");
                if (berryItem != null) {
                    int count = 2 + world.rand.nextInt(3);
                    this.dropBlockAsItem(world, x, y, z, new ItemStack(berryItem, count, 0));
                }
                world.setBlockMetadataWithNotify(x, y, z, 1, 3);
            }
            return true;
        }
        return false;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        Block present = world.getBlock(x, y, z);
        if (present == Blocks.tallgrass || present == Blocks.deadbush) {
            world.setBlockToAir(x, y, z);
        }
        super.onBlockAdded(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor) {
        super.onNeighborBlockChange(world, x, y, z, neighbor);
        if (!this.canBlockStay(world, x, y, z)) {
            if (!world.isRemote) {
                this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            }
            world.setBlockToAir(x, y, z);
        }
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        if (!this.canBlockStay(world, x, y, z)) {
            if (!world.isRemote) {
                this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            }
            world.setBlockToAir(x, y, z);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 3 && rand.nextInt(10) == 0) {
            int newMeta = meta + 1;
            world.setBlockMetadataWithNotify(x, y, z, newMeta, 3);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return world.getBlockMetadata(x, y, z) < 3 && this.canBlockStay(world, x, y, z);
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        if (!this.canBlockStay(world, x, y, z)) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 3) {
            world.setBlockMetadataWithNotify(x, y, z, meta + 1, 3);
        }
    }

    public Item getItemDropped(int meta, Random rand, int fortune) {
        Item berry = (Item)Item.itemRegistry.getObject("BiomesOPlenty:food");
        return berry != null ? berry : Item.getItemFromBlock((Block)this);
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        if (meta >= 3) {
            return 2 + rand.nextInt(3);
        }
        return 1;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!world.isRemote) {
            this.dropBlockAsItem(world, x, y, z, meta, 0);
        }
        super.onBlockHarvested(world, x, y, z, meta, player);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.harvestBlock(world, player, x, y, z, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister reg) {
        this.icons[0] = reg.registerIcon("bopintegration:berry_bush_stage0");
        this.icons[1] = reg.registerIcon("bopintegration:berry_bush_stage1");
        this.icons[2] = reg.registerIcon("bopintegration:berry_bush_stage2");
        this.icons[3] = reg.registerIcon("bopintegration:berry_bush_stage3");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta < 0) {
            meta = 0;
        }
        if (meta > 3) {
            meta = 3;
        }
        return this.icons[meta];
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.getItemDropped(metadata, world.rand, fortune);
        int qty = this.quantityDropped(metadata, fortune, world.rand);
        if (item != null && qty > 0) {
            drops.add(new ItemStack(item, qty));
        }
        return drops;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        world.setBlockMetadataWithNotify(x, y, z, 0, 3);
    }
}

