/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.tweaks.world;

import com.vladmarica.bopIntegration.BOPIntegrationMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBerryBush
extends WorldGenerator {
    private final Block bushBlock;
    private final int bushMeta;

    public WorldGenBerryBush(Block block, int meta) {
        this.bushBlock = block;
        this.bushMeta = meta;
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        int clusterSize = BOPIntegrationMod.config.berryClusterSize;
        if (clusterSize < 1) {
            clusterSize = 1;
        }
        for (int i = 0; i < clusterSize; ++i) {
            int placeY;
            int dy;
            int dx = x + rand.nextInt(4) - rand.nextInt(4);
            int dz = z + rand.nextInt(4) - rand.nextInt(4);
            for (dy = y; dy > 1 && world.isAirBlock(dx, dy, dz); --dy) {
            }
            Block ground = world.getBlock(dx, dy, dz);
            if (ground != Blocks.grass && ground != Blocks.dirt || !world.isAirBlock(dx, placeY = dy + 1, dz) || !this.bushBlock.canBlockStay(world, dx, placeY, dz)) continue;
            world.setBlock(dx, placeY, dz, this.bushBlock, this.bushMeta, 2);
        }
        return true;
    }
}

