/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.common.blocks.BlockBOPFoliage;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import com.vladmarica.bopIntegration.Config;
import com.vladmarica.bopIntegration.ic2.IC2CompatWorldGenerator;
import com.vladmarica.bopIntegration.thaumcraft.ThaumcraftModCompat;
import com.vladmarica.bopIntegration.tweaks.BOPLegacyWorldGenerator;
import com.vladmarica.bopIntegration.tweaks.WorldGenNothing;
import com.vladmarica.bopIntegration.tweaks.WorldGenWaspHiveFixed;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="BOPIntegration", name="BOPIntegration", version="1.1 - Kittified", dependencies="required-after:BiomesOPlenty")
public class BOPIntegrationMod {
    public static final Logger logger = LogManager.getLogger((String)"BOPIntegration");
    public static Config config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Config(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BOPLegacyWorldGenerator(), (int)0);
        this.cakeCleanup();
        if (BOPIntegrationMod.config.waspHiveRarityModifier > 0.0f) {
            WorldGenFieldAssociation.associateFeature((String)"waspHivesPerChunk", (WorldGenerator)new WorldGenWaspHiveFixed());
        }
        if (BOPIntegrationMod.config.removeNetherGravestones) {
            WorldGenFieldAssociation.associateFeature((String)"gravesPerChunk", (WorldGenerator)new WorldGenNothing());
        }
        if (BOPIntegrationMod.config.craftableRottenFlesh) {
            Item rottenFleshItem;
            block22: {
                try {
                    Field rottenFleshField = Items.class.getDeclaredField("rotten_flesh");
                    rottenFleshItem = (Item)rottenFleshField.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    rottenFleshItem = (Item)Item.itemRegistry.getObject("rotten_flesh");
                    if (rottenFleshItem != null) break block22;
                    logger.error("Failed to get rotten flesh item!");
                    return;
                }
            }
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(rottenFleshItem, 4), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), new ItemStack(BOPCItems.misc, 1, 3), Character.valueOf('X'), new ItemStack(BOPCBlocks.flowers, 1, 13)});
        }
        if (BOPIntegrationMod.config.removeEnderporterRecipe) {
            ItemStack enderporter = new ItemStack(BOPCItems.enderporter, 1);
            if (BOPIntegrationMod.removeRecipe(enderporter)) {
                logger.info("Removed Enderporter recipe");
            } else {
                logger.error("Failed to remove Enderporter recipe!");
            }
        }
        if (BOPIntegrationMod.config.harderBiomeFinderRecipe) {
            ItemStack biomeFinder = new ItemStack(BOPCItems.biomeFinder, 1);
            if (BOPIntegrationMod.removeRecipe(biomeFinder)) {
                Item crystalItem;
                Item emeraldItem;
                block23: {
                    emeraldItem = null;
                    crystalItem = null;
                    try {
                        Field emeraldField = Items.class.getDeclaredField("emerald");
                        emeraldItem = (Item)emeraldField.get(null);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        emeraldItem = (Item)Item.itemRegistry.getObject("emerald");
                        if (emeraldItem != null) break block23;
                        emeraldItem = (Item)Item.itemRegistry.getObject("minecraft:emerald");
                    }
                }
                try {
                    crystalItem = (Item)Item.itemRegistry.getObject("BiomesOPlenty:crystal");
                }
                catch (Exception e) {
                    logger.error("Failed to get crystal item");
                }
                if (emeraldItem != null && crystalItem != null) {
                    GameRegistry.addShapedRecipe((ItemStack)new ItemStack(BOPCItems.biomeFinder, 1), (Object[])new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), new ItemStack(emeraldItem, 1), Character.valueOf('X'), new ItemStack(crystalItem, 1), Character.valueOf('Y'), new ItemStack(BOPCItems.misc, 1, 10)});
                } else {
                    logger.error("Failed to add harder Biome Finder recipe - missing items");
                }
            } else {
                logger.error("Failed to remove Biome Finder recipe!");
            }
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            ThaumcraftModCompat.apply();
        } else {
            logger.info("Thaumcraft not found - skipping integration patch");
        }
        if (Loader.isModLoaded((String)"IC2") && BOPIntegrationMod.config.fixIC2RubberTrees) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new IC2CompatWorldGenerator(), (int)10);
            logger.info("IC2 rubber tree fix applied");
        } else if (BOPIntegrationMod.config.fixIC2RubberTrees) {
            logger.info("IC2 not found - skipping rubber tree fix");
        }
    }

    public static boolean unregisterWorldGenerator(IWorldGenerator worldGenerator) {
        try {
            Field worldGeneratorsField = GameRegistry.class.getDeclaredField("worldGenerators");
            worldGeneratorsField.setAccessible(true);
            Field worldGeneratorIndexField = GameRegistry.class.getDeclaredField("worldGeneratorIndex");
            worldGeneratorIndexField.setAccessible(true);
            Set generators = (Set)worldGeneratorsField.get(worldGenerator);
            Map generatorIndexMap = (Map)worldGeneratorIndexField.get(worldGenerator);
            if (!generators.contains(worldGenerator)) {
                return false;
            }
            generators.remove(worldGenerator);
            generatorIndexMap.remove(worldGenerator);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean removeRecipe(ItemStack output) {
        if (output == null) {
            return false;
        }
        try {
            Field instanceField = CraftingManager.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            CraftingManager craftingManager = (CraftingManager)instanceField.get(null);
            List recipes = craftingManager.getRecipeList();
            boolean removed = false;
            for (int i = 0; i < recipes.size(); ++i) {
                ItemStack recipeOutput;
                IRecipe recipe = (IRecipe)recipes.get(i);
                if (recipe == null || (recipeOutput = recipe.getRecipeOutput()) == null) continue;
                ItemStack compareOutput = output.copy();
                compareOutput.stackSize = 1;
                recipeOutput = recipeOutput.copy();
                recipeOutput.stackSize = 1;
                if (!ItemStack.areItemStacksEqual((ItemStack)compareOutput, (ItemStack)recipeOutput)) continue;
                recipes.remove(i--);
                removed = true;
                logger.info("Removed recipe for: " + output.getDisplayName());
            }
            return removed;
        }
        catch (Exception ex) {
            logger.error("Error removing recipe for " + output.getDisplayName() + ": ", (Throwable)ex);
            return false;
        }
    }

    private static List<IRecipe> getIRecipes(ItemStack output, CraftingManager craftingManager) {
        ArrayList<IRecipe> recipesToRemove = new ArrayList<IRecipe>();
        for (Object obj : craftingManager.getRecipeList()) {
            IRecipe recipe;
            ItemStack thisOutput;
            if (!(obj instanceof IRecipe) || (thisOutput = (recipe = (IRecipe)obj).getRecipeOutput()) == null || thisOutput.getItem() != output.getItem() || thisOutput.getItemDamage() != output.getItemDamage()) continue;
            recipesToRemove.add(recipe);
        }
        return recipesToRemove;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.block.getClass() == BlockBOPFoliage.class && event.blockMetadata == 12) {
            event.drops.clear();
            event.dropChance = 1.0f;
            event.drops.add(new ItemStack(BOPCItems.turnipSeeds, 1));
        }
    }

    private void cakeCleanup() {
        try {
            Field handlersField = EventBus.class.getDeclaredField("listeners");
            handlersField.setAccessible(true);
            ConcurrentHashMap listeners = (ConcurrentHashMap)handlersField.get(FMLCommonHandler.instance().bus());
            for (Object o : listeners.keySet()) {
                if (!o.getClass().getSimpleName().equals("EventHandlerCake")) continue;
                FMLCommonHandler.instance().bus().unregister(o);
                logger.info("Unregistered cake crafting handler");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

