/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.tweaks;

import biomesoplenty.api.content.BOPCBlocks;
import com.vladmarica.bopIntegration.BOPIntegrationMod;
import com.vladmarica.bopIntegration.tweaks.WorldGenCrystals;
import cpw.mods.fml.common.IWorldGenerator;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class BOPLegacyWorldGenerator
implements IWorldGenerator {
    private WorldGenCrystals crystalGenerator = new WorldGenCrystals();
    private Field providerField = null;

    public BOPLegacyWorldGenerator() {
        try {
            this.providerField = World.class.getDeclaredField("provider");
            this.providerField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BOPIntegrationMod.logger.error("Could not find provider field in World class", (Throwable)e);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            Object provider = this.providerField.get(world);
            Field dimensionIdField = provider.getClass().getDeclaredField("dimensionId");
            dimensionIdField.setAccessible(true);
            int dimensionId = (Integer)dimensionIdField.get(provider);
            if (dimensionId == 1) {
                this.generateEnd(random, chunkX, chunkZ, world);
            }
        }
        catch (Exception e) {
            try {
                if (world.provider.dimensionId == 1) {
                    this.generateEnd(random, chunkX, chunkZ, world);
                }
            }
            catch (NoSuchFieldError ex) {
                BOPIntegrationMod.logger.error("Failed to access dimension ID", (Throwable)ex);
            }
        }
    }

    private void generateEnd(Random random, int chunkX, int chunkZ, World world) {
        int z;
        int y;
        int x;
        int i;
        if (BOPIntegrationMod.config.genBiomeEssence) {
            for (i = 0; i < 30; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                if (world.getBlock(x, y = 10 + random.nextInt(60), z = chunkZ * 16 + random.nextInt(16)) != Blocks.end_stone) continue;
                world.setBlock(x, y, z, BOPCBlocks.biomeBlock);
            }
        }
        if (BOPIntegrationMod.config.genCelestialCrystals) {
            for (i = 0; i < 40; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = 10 + random.nextInt(60);
                z = chunkZ * 16 + random.nextInt(16);
                this.crystalGenerator.generate(world, random, x, y, z);
            }
        }
    }
}

