/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.thaumcraft;

import biomesoplenty.api.biome.BOPBiome;
import com.vladmarica.bopIntegration.BOPIntegrationMod;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.common.lib.world.WorldGenSilverwoodTrees;

public class ThaumcraftCompatWorldGenerator
implements IWorldGenerator {
    private WorldGenSilverwoodTrees silverwoodTreeGen = new WorldGenSilverwoodTrees(false, 7, 4);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!BOPIntegrationMod.config.fixSilverwoodTrees) {
            return;
        }
        if (world.field_73011_w.field_76574_g == 0) {
            BiomeGenBase biome = world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
            if (!(biome instanceof BOPBiome)) {
                return;
            }
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
                return;
            }
            int chance = 75;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
                chance = 130;
            }
            if (random.nextInt(chance) == 3) {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                int y = world.func_72976_f(x, z);
                this.silverwoodTreeGen.func_76484_a(world, random, x, y, z);
            }
        }
    }
}

