/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.tweaks;

import biomesoplenty.api.content.BOPCBlocks;
import com.vladmarica.bopIntegration.BOPIntegrationMod;
import com.vladmarica.bopIntegration.tweaks.world.WorldGenCrystals;
import cpw.mods.fml.common.IWorldGenerator;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class BOPLegacyWorldGenerator
implements IWorldGenerator {
    private WorldGenCrystals crystalGenerator = new WorldGenCrystals();
    private Field providerField = null;

    public BOPLegacyWorldGenerator() {
        try {
            this.providerField = World.class.getDeclaredField("provider");
            this.providerField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BOPIntegrationMod.logger.error("Could not find provider field in World class", (Throwable)e);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        block10: {
            try {
                Object provider = this.providerField.get(world);
                Field dimensionIdField = provider.getClass().getDeclaredField("dimensionId");
                dimensionIdField.setAccessible(true);
                int dimensionId = (Integer)dimensionIdField.get(provider);
                if (dimensionId == 1) {
                    this.generateEnd(random, chunkX, chunkZ, world);
                }
                if (dimensionId != 0 || BOPIntegrationMod.config.genAmethystOreOverworld) break block10;
                try {
                    Block gemOre = Block.getBlockFromName((String)"biomesoplenty:gem_ore");
                    if (gemOre != null) {
                        BOPIntegrationMod.logger.info("Skipping biomesoplenty:gem_ore generation in Overworld (config disabled).");
                    } else {
                        BOPIntegrationMod.logger.warn("biomesoplenty:gem_ore block not found while disabling Overworld generation.");
                    }
                }
                catch (Exception ex) {
                    BOPIntegrationMod.logger.warn("Error while disabling amethyst ore generation in Overworld", (Throwable)ex);
                }
                return;
            }
            catch (Exception e) {
                try {
                    if (world.provider.dimensionId == 1) {
                        this.generateEnd(random, chunkX, chunkZ, world);
                    }
                }
                catch (NoSuchFieldError ex) {
                    BOPIntegrationMod.logger.error("Failed to access dimension ID", (Throwable)ex);
                }
            }
        }
    }

    private void generateEnd(Random random, int chunkX, int chunkZ, World world) {
        int z;
        int y;
        int x;
        int i;
        if (BOPIntegrationMod.config.genBiomeEssence) {
            for (i = 0; i < 30; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                if (world.getBlock(x, y = 10 + random.nextInt(60), z = chunkZ * 16 + random.nextInt(16)) != Blocks.end_stone) continue;
                world.setBlock(x, y, z, BOPCBlocks.biomeBlock);
            }
        }
        if (BOPIntegrationMod.config.genCelestialCrystals) {
            for (i = 0; i < 40; ++i) {
                x = chunkX * 16 + random.nextInt(16);
                y = 10 + random.nextInt(60);
                z = chunkZ * 16 + random.nextInt(16);
                this.crystalGenerator.generate(world, random, x, y, z);
            }
        }
        if (BOPIntegrationMod.config.amethystEndGen) {
            Block gemOre = Block.getBlockFromName((String)"BiomesOPlenty:gemOre");
            if (gemOre == null) {
                BOPIntegrationMod.logger.warn("Cannot find block Ender Amethyst ore (BiomesOPlenty:gemOre); skipping End generation.");
                return;
            }
            for (int i2 = 0; i2 < 30; ++i2) {
                int z2;
                int y2;
                int x2 = chunkX * 16 + random.nextInt(16);
                if (world.getBlock(x2, y2 = random.nextInt(31), z2 = chunkZ * 16 + random.nextInt(16)) != Blocks.end_stone) continue;
                world.setBlock(x2, y2, z2, gemOre, 0, 2);
            }
        }
    }
}

