/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.bopIntegration.tweaks.event;

import biomesoplenty.api.content.BOPCItems;
import com.vladmarica.bopIntegration.BOPIntegrationMod;
import com.vladmarica.bopIntegration.tweaks.BlockBOPBerryBush;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventBerryPlanting {
    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent event) {
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (event.world.isRemote) {
            Block above;
            Item berry;
            ItemStack held = event.entityPlayer.getHeldItem();
            if (held != null && (berry = (Item)Item.itemRegistry.getObject("BiomesOPlenty:food")) != null && held.getItem() == berry && ((above = event.world.getBlock(x, y + 1, z)) == Blocks.tallgrass || above == Blocks.deadbush || above == Blocks.double_plant)) {
                event.setCanceled(true);
            }
            return;
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        World world = event.world;
        ItemStack held = player.getHeldItem();
        if (held == null) {
            return;
        }
        Item bopBerry = BOPCItems.food;
        if (bopBerry == null) {
            return;
        }
        Item bushItem = Item.getItemFromBlock((Block)BOPIntegrationMod.bopBerryBush);
        if (held.getItem() == bushItem) {
            return;
        }
        if (held.getItem() != bopBerry) {
            return;
        }
        if (held.getItemDamage() != 0) {
            return;
        }
        if (event.face != 1) {
            return;
        }
        Block soil = world.getBlock(x, y, z);
        if (soil != Blocks.grass && soil != Blocks.dirt && soil != Blocks.farmland) {
            return;
        }
        Block above = world.getBlock(x, y + 1, z);
        if (above == Blocks.tallgrass || above == Blocks.deadbush) {
            world.setBlockToAir(x, y + 1, z);
        } else {
            if (above == Blocks.red_flower || above == Blocks.yellow_flower || above == Blocks.double_plant) {
                return;
            }
            if (!world.isAirBlock(x, y + 1, z)) {
                return;
            }
        }
        BlockBOPBerryBush bush = (BlockBOPBerryBush)BOPIntegrationMod.bopBerryBush;
        if (world.setBlock(x, y + 1, z, (Block)bush, 0, 3)) {
            world.setBlockMetadataWithNotify(x, y + 1, z, 0, 3);
            if (!player.capabilities.isCreativeMode) {
                --held.stackSize;
                if (held.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
                }
            }
            event.setCanceled(true);
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new EventBerryPlanting());
    }
}

