/*
 * Decompiled with CFR 0.152.
 */
package me.local.easyban;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyBan
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private File bansFile;
    private FileConfiguration bansConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.createBansFile();
        this.getCommand("eb").setExecutor((CommandExecutor)this);
        this.getCommand("eb").setTabCompleter((TabCompleter)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("EasyBan loaded successfully!");
    }

    public void onDisable() {
        this.getLogger().info("EasyBan disabled.");
    }

    private void createBansFile() {
        this.bansFile = new File(this.getDataFolder(), "bans.yml");
        if (!this.bansFile.exists()) {
            try {
                this.bansFile.createNewFile();
            }
            catch (IOException iOException) {
                this.getLogger().severe("Could not create bans.yml!");
                iOException.printStackTrace();
            }
        }
        this.bansConfig = YamlConfiguration.loadConfiguration((File)this.bansFile);
    }

    private void saveBans() {
        try {
            this.bansConfig.save(this.bansFile);
        }
        catch (IOException iOException) {
            this.getLogger().severe("Could not save bans.yml!");
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length == 0) {
            commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.RED) + " Usage: /eb <subcommand> [args]");
            return true;
        }
        String string2 = stringArray[0].toLowerCase();
        if (!commandSender.hasPermission("easyban.use")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return true;
        }
        switch (string2) {
            case "ban": {
                this.handleBan(commandSender, stringArray, false);
                break;
            }
            case "tempban": {
                this.handleBan(commandSender, stringArray, true);
                break;
            }
            case "mute": {
                this.handleMute(commandSender, stringArray, false);
                break;
            }
            case "tempmute": {
                this.handleMute(commandSender, stringArray, true);
                break;
            }
            case "kick": {
                this.handleKick(commandSender, stringArray);
                break;
            }
            case "delban": {
                this.handleUnban(commandSender, stringArray);
                break;
            }
            case "delmute": {
                this.handleUnmute(commandSender, stringArray);
                break;
            }
            case "reload": {
                if (!commandSender.hasPermission("easyban.admin")) {
                    commandSender.sendMessage(this.msg("messages.no-permission"));
                    return true;
                }
                this.reloadConfig();
                this.createBansFile();
                commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Configuration reloaded.");
                break;
            }
            default: {
                commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.RED) + " Unknown subcommand. Use /eb tab for help.");
            }
        }
        return true;
    }

    private void handleBan(CommandSender commandSender, String[] stringArray, boolean bl) {
        String string;
        int n;
        if (!commandSender.hasPermission("easyban.ban")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return;
        }
        int n2 = n = bl ? 4 : 2;
        if (stringArray.length < n) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /eb " + (bl ? "tempban <player> <time> <s/m/h/d> <reason>" : "ban <player> <reason>"));
            return;
        }
        String string2 = stringArray[1];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string2);
        long l = -1L;
        Object object = "Permanent";
        if (bl) {
            long l2 = this.parseTime(stringArray[2], stringArray[3]);
            if (l2 <= 0L) {
                commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time format. Use: 10 s, 5 m, 1 h, 1 d");
                return;
            }
            l = System.currentTimeMillis() + l2;
            object = stringArray[2] + stringArray[3];
            string = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 4, stringArray.length));
        } else {
            string = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 2, stringArray.length));
        }
        if (string.isEmpty()) {
            string = "No reason provided";
        }
        String string3 = "bans." + offlinePlayer.getUniqueId().toString();
        this.bansConfig.set(string3 + ".name", (Object)string2);
        this.bansConfig.set(string3 + ".reason", (Object)string);
        this.bansConfig.set(string3 + ".admin", (Object)commandSender.getName());
        this.bansConfig.set(string3 + ".expiry", (Object)l);
        this.bansConfig.set(string3 + ".date", (Object)new Date().toString());
        this.saveBans();
        if (offlinePlayer.isOnline()) {
            String string4 = this.msg("messages.banned-layout").replace("%reason%", string).replace("%admin%", commandSender.getName()).replace("%time%", (CharSequence)object);
            offlinePlayer.getPlayer().kickPlayer(string4);
        }
        commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Player " + string2 + " has been banned (" + (String)object + ").");
        this.logHistory("BAN", string2, commandSender.getName(), string, (String)object);
    }

    private void handleMute(CommandSender commandSender, String[] stringArray, boolean bl) {
        String string;
        int n;
        if (!commandSender.hasPermission("easyban.mute")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return;
        }
        int n2 = n = bl ? 4 : 2;
        if (stringArray.length < n) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /eb " + (bl ? "tempmute <player> <time> <s/m/h/d> <reason>" : "mute <player> <reason>"));
            return;
        }
        String string2 = stringArray[1];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string2);
        long l = -1L;
        Object object = "Permanent";
        if (bl) {
            long l2 = this.parseTime(stringArray[2], stringArray[3]);
            if (l2 <= 0L) {
                commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time format.");
                return;
            }
            l = System.currentTimeMillis() + l2;
            object = stringArray[2] + stringArray[3];
            string = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 4, stringArray.length));
        } else {
            string = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 2, stringArray.length));
        }
        if (string.isEmpty()) {
            string = "No reason";
        }
        String string3 = "mutes." + offlinePlayer.getUniqueId().toString();
        this.bansConfig.set(string3 + ".name", (Object)string2);
        this.bansConfig.set(string3 + ".reason", (Object)string);
        this.bansConfig.set(string3 + ".admin", (Object)commandSender.getName());
        this.bansConfig.set(string3 + ".expiry", (Object)l);
        this.bansConfig.set(string3 + ".date", (Object)new Date().toString());
        this.saveBans();
        if (offlinePlayer.isOnline()) {
            offlinePlayer.getPlayer().sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.RED) + " You have been muted by " + commandSender.getName() + " for: " + string);
        }
        commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Player " + string2 + " muted (" + (String)object + ").");
        this.logHistory("MUTE", string2, commandSender.getName(), string, (String)object);
    }

    private void handleKick(CommandSender commandSender, String[] stringArray) {
        if (!commandSender.hasPermission("easyban.kick")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return;
        }
        if (stringArray.length < 2) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /eb kick <player> <reason>");
            return;
        }
        Player player = Bukkit.getPlayer((String)stringArray[1]);
        if (player == null) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found online.");
            return;
        }
        String string = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 2, stringArray.length));
        if (string.isEmpty()) {
            string = "Kicked by admin";
        }
        player.kickPlayer(String.valueOf(ChatColor.RED) + "KICKED: " + string);
        commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Player " + player.getName() + " kicked.");
        this.logHistory("KICK", player.getName(), commandSender.getName(), string, "Instant");
    }

    private void handleUnban(CommandSender commandSender, String[] stringArray) {
        if (!commandSender.hasPermission("easyban.unban")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return;
        }
        if (stringArray.length < 2) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /eb delban <player>");
            return;
        }
        String string = stringArray[1];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        String string2 = "bans." + offlinePlayer.getUniqueId().toString();
        if (this.bansConfig.contains(string2)) {
            this.bansConfig.set(string2, null);
            this.saveBans();
            commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Player " + string + " unbanned.");
            this.logHistory("UNBAN", string, commandSender.getName(), "Manual unban", "-");
        } else {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Player is not banned.");
        }
    }

    private void handleUnmute(CommandSender commandSender, String[] stringArray) {
        if (!commandSender.hasPermission("easyban.unmute")) {
            commandSender.sendMessage(this.msg("messages.no-permission"));
            return;
        }
        if (stringArray.length < 2) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /eb delmute <player>");
            return;
        }
        String string = stringArray[1];
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        String string2 = "mutes." + offlinePlayer.getUniqueId().toString();
        if (this.bansConfig.contains(string2)) {
            this.bansConfig.set(string2, null);
            this.saveBans();
            commandSender.sendMessage(this.msg("messages.prefix") + String.valueOf(ChatColor.GREEN) + " Player " + string + " unmuted.");
            this.logHistory("UNMUTE", string, commandSender.getName(), "Manual unmute", "-");
        } else {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Player is not muted.");
        }
    }

    @EventHandler
    public void onLogin(AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent) {
        String string = "bans." + asyncPlayerPreLoginEvent.getUniqueId().toString();
        if (this.bansConfig.contains(string)) {
            long l = this.bansConfig.getLong(string + ".expiry");
            if (l != -1L && System.currentTimeMillis() > l) {
                this.bansConfig.set(string, null);
                this.saveBans();
                return;
            }
            String string2 = this.bansConfig.getString(string + ".reason");
            String string3 = this.bansConfig.getString(string + ".admin");
            String string4 = l == -1L ? "Permanent" : new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(l));
            String string5 = this.msg("messages.banned-layout").replace("%reason%", string2).replace("%admin%", string3).replace("%time%", string4);
            asyncPlayerPreLoginEvent.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, string5);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        String string = "mutes." + player.getUniqueId().toString();
        if (this.bansConfig.contains(string)) {
            long l = this.bansConfig.getLong(string + ".expiry");
            if (l != -1L && System.currentTimeMillis() > l) {
                this.bansConfig.set(string, null);
                this.saveBans();
                return;
            }
            String string2 = this.bansConfig.getString(string + ".reason");
            asyncPlayerChatEvent.setCancelled(true);
            player.sendMessage(this.msg("messages.muted-message").replace("%reason%", string2));
        }
    }

    private long parseTime(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            long l = 0L;
            switch (string2.toLowerCase()) {
                case "s": {
                    l = 1000L;
                    break;
                }
                case "m": {
                    l = 60000L;
                    break;
                }
                case "h": {
                    l = 3600000L;
                    break;
                }
                case "d": {
                    l = 86400000L;
                }
            }
            return (long)n * l;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private String msg(String string) {
        String string2 = this.getConfig().getString(string);
        if (string2 == null) {
            return string;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
    }

    private void logHistory(String string, String string2, String string3, String string4, String string5) {
        String string6 = UUID.randomUUID().toString().substring(0, 8);
        String string7 = string + " | " + string2 + " | By: " + string3 + " | " + string5 + " | " + string4;
        this.bansConfig.set("history." + string6, (Object)string7);
        this.saveBans();
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length == 1) {
            return Arrays.asList("ban", "tempban", "mute", "tempmute", "kick", "delban", "delmute", "reload");
        }
        if (stringArray.length == 2) {
            return null;
        }
        if (stringArray.length == 4 && (stringArray[0].equalsIgnoreCase("tempban") || stringArray[0].equalsIgnoreCase("tempmute"))) {
            return Arrays.asList("s", "m", "h", "d");
        }
        return new ArrayList<String>();
    }
}

