package chaos.sculklatch.blocks.custom;

import chaos.sculklatch.blocks.entities.ModBlockEntities;
import chaos.sculklatch.blocks.entities.custom.SculkChestBlockEntity;
import net.minecraft.block.*;
import net.minecraft.block.entity.*;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7124;
import net.minecraft.class_7128;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

public class SculkChestBlock extends class_2281 implements class_2343, class_7124 {

    public static final class_2746 IS_SCARED = class_2746.method_11825("is_scared");
    private class_3222 lastPlayerToOpen;

    public SculkChestBlock(Supplier<class_2591<? extends class_2595>> blockEntityTypeSupplier, class_2251 settings) {
        super(blockEntityTypeSupplier, settings);
        this.method_9590(this.field_10647.method_11664().method_11657(IS_SCARED, false).method_11657(field_10768, class_2350.field_11043).method_11657(field_10772, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(IS_SCARED);
    }


    @Override
    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        if (state.method_11654(IS_SCARED)) {
            System.out.println("breaking");
            return super.method_9594(state, player, world, pos) * 20f; // Hardness when powered
        } else {
            return super.method_9594(state, player, world, pos); // Default hardness
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        if (!state.method_11654(IS_SCARED) && this.lastPlayerToOpen != null) {
            this.lastPlayerToOpen.method_7346();
        }
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return class_1802.field_8106.method_7854();
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SculkChestBlockEntity(pos, state);
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, ModBlockEntities.SCULK_CHEST_BLOCK_ENTITY_TYPE, SculkChestBlockEntity::tick);
    }



    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (state.method_11654(IS_SCARED)) {
            if (!world.method_8608()) {
                this.lastPlayerToOpen = (class_3222) player;
            }
            return super.method_55766(state, world, pos, player, hit);
        }
        return class_1269.field_5811;
    }

    @Override
    public int method_41471(class_7128.class_7129 cursor, class_1936 world, class_2338 catalystPos, class_5819 random, class_7128 spreadManager, boolean shouldConvertToBlock) {
        return cursor.method_41508();
    }
}
