package chaos.sculklatch.blocks.custom;

import chaos.sculklatch.SculkLatch;
import chaos.sculklatch.damagetype.ModDamageSources;
import chaos.sculklatch.tags.ModTags;
import net.minecraft.block.*;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_7124;
import net.minecraft.class_7125;
import net.minecraft.class_7260;
import net.minecraft.util.math.*;

public class SculkJawBlock extends class_7125 implements class_7124 {
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2746 IS_SCARED = class_2746.method_11825("is_scared");
    public static final class_2746 IS_EATING = class_2746.method_11825("is_eating");
    public static final class_2758 HEALTH = class_2758.method_11867("health", 0, SculkLatch.SCULK_JAW_HEALTH);
    private static final class_265 COLLISION_SHAPE = class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    private static final class_265 FULL_COLLISION_SHAPE = class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);

    public SculkJawBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043).method_11657(IS_SCARED, false).method_11657(HEALTH, SculkLatch.SCULK_JAW_HEALTH).method_11657(IS_EATING, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
        builder.method_11667(IS_SCARED);
        builder.method_11667(IS_EATING);
        builder.method_11667(HEALTH);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042());
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727) {
            class_1297 entity = ((class_3727) context).method_32480();

            if (entity != null) {
                if (entity.method_5864().method_20210(ModTags.SCULK_JAW_IMMUNE)) {
                    return FULL_COLLISION_SHAPE;
                }
                if (entity.method_5715() && entity.method_5707(pos.method_46558().method_1031(0, 0.5,0)) > 0.039) {
                    return FULL_COLLISION_SHAPE;
                }
            }
        }
        if (state.method_11654(IS_SCARED) || (!context.method_16192(COLLISION_SHAPE.method_1096(0, 0.3, 0), pos, true))) {
            return FULL_COLLISION_SHAPE;
        }
        return COLLISION_SHAPE;
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (entity instanceof class_1309 && !state.method_11654(IS_SCARED) && !(entity.method_5864().method_20210(ModTags.SCULK_JAW_IMMUNE))) {
            if (entity instanceof class_1657 && ((class_1657) entity).method_31549().field_7479) {
                return;
            }
            entity.method_5660(false);
            if (world instanceof class_3218 serverWorld) {
                entity.method_64397(serverWorld, world.method_48963().method_48795(ModDamageSources.SCULK_JAW), 1.0F);
            }
            entity.method_60491(pos.method_46558().method_1031(0, -0.3, 0).method_1020(entity.method_19538()).method_1021(0.3));
            entity.method_5844(state, new class_243(0.5, 0.6, 0.5));
        }
    }

    @Override
    public class_265 method_9571(class_2680 state) {
        return class_259.method_1073();
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        if (state.method_11654(IS_SCARED)) {
            world.method_8501(pos, state.method_11657(IS_SCARED, false).method_11657(HEALTH, SculkLatch.SCULK_JAW_HEALTH));
        }
    }

    @Override
    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!state.method_11654(IS_SCARED)) {
            damageSculkJaw(player, pos, state);
            if (state.method_11654(HEALTH) <= 0) {
                if (!world.method_8608()) {
                    world.method_64310(pos, this, 600);
                    world.method_8501(pos, state.method_11657(IS_SCARED, true).method_11657(HEALTH, SculkLatch.SCULK_JAW_HEALTH));
                }
            }
        }
        super.method_9606(state, world, pos, player);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!state.method_11654(IS_EATING) && !world.method_8390(class_1297.class, class_238.method_30048(pos.method_46558(), 0.5, 0.5, 0.5), class_1301.field_6155).isEmpty()) {
            world.method_8501(pos, state.method_11657(IS_EATING, true));
        }
        if (state.method_11654(IS_EATING) && world.method_8390(class_1297.class, class_238.method_30048(pos.method_46558(), 0.5, 0.5, 0.5), class_1301.field_6155).isEmpty()) {
            world.method_8501(pos, state.method_11657(IS_EATING, false));
        }
        super.method_9496(state, world, pos, random);
    }

    public void damageSculkJaw(class_1657 player, class_2338 pos, class_2680 state) {
        if (player.method_37908().method_8608()) {
            return;
        }
        float f = (float) player.method_45325(class_5134.field_23721);

        float g = class_1890.method_60120((class_3218) player.method_37908(), player.method_59958(), new class_7260(class_1299.field_38095, player.method_37908()), player.method_48923().method_48802(player), f);
        float h = player.method_7261(0.5F);
        f *= 0.2F + h * h * 0.8F;
        g *= h;
        player.method_7350();
        if (f > 0.0F || g > 0.0F) {
            boolean bl = h > 0.9F;
            boolean bl2 = player.method_5624() && bl;
            boolean bl3 = bl && player.field_6017 > 0.0F && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765();
            bl3 = bl3 && !player.method_5624();
            if (bl3) {
                f *= 1.5F;
            }

            f += g;
            boolean bl4 = false;
            double d = player.method_60478().method_37268();
            double e = player.method_6029() * 2.5;
            if (bl && !bl3 && !bl2 && player.method_24828() && d < (double) player.method_6029()) {
                class_1799 itemStack = player.method_5998(class_1268.field_5808);
                if (d < class_3532.method_33723(e) && player.method_5998(class_1268.field_5808).method_31573(class_3489.field_42611)) {
                    bl4 = true;
                }
            }

            if (bl4) {
                float l = 1.0F + (float)player.method_45325(class_5134.field_51577) * f;

                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14706, player.method_5634(), 1.0F, 1.0F);
                player.method_7263();


                if (player.method_5707(pos.method_46558()) < 9.0) {
                    player.method_37908().method_8501(pos, state.method_11657(HEALTH, Math.max(0, state.method_11654(HEALTH) - ((int) l * 5))));
                }
            }

            if (bl3) {
                player.method_37908().method_8501(pos, state.method_11657(HEALTH, Math.max(0, state.method_11654(HEALTH) - ((int) f))));
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15016, player.method_5634(), 1.0F, 1.0F);
            }

            if (!bl3 && !bl4) {
                player.method_37908().method_43276(class_5712.field_28736, pos, new class_5712.class_7397(player, null));
                if (bl) {
                    player.method_37908().method_8501(pos, state.method_11657(HEALTH, Math.max(0, state.method_11654(HEALTH) - ((int) f))));
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14840, player.method_5634(), 1.0F, 1.0F);
                } else {
                    player.method_37908().method_8501(pos, state.method_11657(HEALTH, Math.max(0, state.method_11654(HEALTH) - ((int) f))));
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14625, player.method_5634(), 1.0F, 1.0F);
                }
            }

            if (!player.method_37908().field_9236) {
                ((class_3218) player.method_37908()).method_65096(class_2398.field_11209, pos.method_10263(), pos.method_10264(), pos.method_10260(), (int) f, 0.1, 0.0, 0.1, 0.2);
            }

            player.method_7322(0.1F);
        }
    }

}
