package chaos.sculklatch.commands;

import chaos.sculklatch.items.custom.components.ModDataComponentTypes;
import chaos.sculklatch.items.custom.components.custom.OverfilledBundleContentComponent;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import java.util.Objects;

import static net.minecraft.class_2170.method_9247;

public class ModCommands {
    public static void registerModCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {

            LiteralArgumentBuilder<class_2168> grub = method_9247("fillBundle");
            grub.executes(context -> {
                class_1799 stack = Objects.requireNonNull(context.getSource().method_44023()).method_6047();
                OverfilledBundleContentComponent bundleContentsComponent = stack.method_58694(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS);
                if (bundleContentsComponent == null) return 0;
                OverfilledBundleContentComponent.Builder builder = new OverfilledBundleContentComponent.Builder(bundleContentsComponent);
                builder.saveAll(context.getSource().method_44023());
                stack.method_57379(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS, builder.build());
                return 1;
            });

            dispatcher.register(grub);
        });
    }
}
