package chaos.sculklatch.items.custom.components.custom;

import chaos.sculklatch.SculkLatch;
import chaos.sculklatch.items.ModItems;
import chaos.sculklatch.items.custom.components.ModDataComponentTypes;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10706;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_4482;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;

public class OverfilledBundleContentComponent implements class_5632 {
    public static final OverfilledBundleContentComponent DEFAULT = new OverfilledBundleContentComponent(List.of());
    public static final Codec<OverfilledBundleContentComponent> CODEC;
    public static final class_9139<class_9129, OverfilledBundleContentComponent> PACKET_CODEC;
    private static final Fraction NESTED_BUNDLE_OCCUPANCY;
    private static final int MAX_ITEMS = 32;  // Maximum number of items in the bundle
    final List<class_1799> stacks;
    final Fraction occupancy;

    OverfilledBundleContentComponent(List<class_1799> stacks, Fraction occupancy) {
        this.stacks = stacks;
        this.occupancy = occupancy;
    }

    public OverfilledBundleContentComponent(List<class_1799> stacks) {
        this(stacks, calculateOccupancy(stacks));
    }

    private static Fraction calculateOccupancy(List<class_1799> stacks) {
        Fraction fraction = Fraction.ZERO;

        class_1799 itemStack;
        for(Iterator<class_1799> var2 = stacks.iterator(); var2.hasNext(); fraction = fraction.add(getOccupancy(itemStack).multiplyBy(Fraction.getFraction(itemStack.method_7947(), 1)))) {
            itemStack = var2.next();
        }

        return fraction;
    }

    static Fraction getOccupancy(class_1799 stack) {
        OverfilledBundleContentComponent overfilledBundleContentsComponent = stack.method_58694(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS);
        if (overfilledBundleContentsComponent != null) {
            return NESTED_BUNDLE_OCCUPANCY.add(overfilledBundleContentsComponent.getOccupancy());
        } else {
            List<class_4482.class_9309> list = (stack.method_58695(class_9334.field_49624, class_10706.field_56300)).comp_3585();
            return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction(1, stack.method_7914() * 10); // muahahahahahahhhh higher capacity size upon ye
        }
    }

    public class_1799 get(int index) {
        return this.stacks.get(index);
    }

    public Stream<class_1799> stream() {
        return this.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return this.stacks;
    }

    public Iterable<class_1799> iterateCopy() {
        return Lists.transform(this.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.stacks.size();
    }

    public Fraction getOccupancy() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (!(o instanceof OverfilledBundleContentComponent bundleContentsComponent)) {
            return false;
        } else {
            return this.occupancy.equals(bundleContentsComponent.occupancy) && class_1799.method_57362(this.stacks, bundleContentsComponent.stacks);
        }
    }

    public int hashCode() {
        return class_1799.method_57361(this.stacks);
    }

    public String toString() {
        return "OverFilledBundleContents" + this.stacks;
    }

    static {
        CODEC = class_1799.field_24671.listOf().xmap(OverfilledBundleContentComponent::new, (component) -> component.stacks);
        PACKET_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(OverfilledBundleContentComponent::new, (component) -> component.stacks);
        NESTED_BUNDLE_OCCUPANCY = Fraction.getFraction(1, MAX_ITEMS);
    }

    public static class Builder {
        private final List<class_1799> stacks;
        private Fraction occupancy;

        public Builder(OverfilledBundleContentComponent base) {
            this.stacks = new ArrayList<>(base.stacks);
            this.occupancy = base.occupancy;
        }

        public OverfilledBundleContentComponent.Builder clear() {
            this.stacks.clear();
            this.occupancy = Fraction.ZERO;
            return this;
        }

        private int addInternal(class_1799 stack) {
            if (stack.method_7946()) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (class_1799.method_31577(this.stacks.get(i), stack)) {
                        return i;
                    }
                }
            }
            return -1;
        }

        private int getMaxAllowed(class_1799 stack) {
            Fraction fraction = Fraction.ONE.subtract(this.occupancy);
            return Math.max(fraction.divideBy(OverfilledBundleContentComponent.getOccupancy(stack)).intValue(), 0);
        }

        private int add(class_1799 stack) {
            if (!stack.method_7960() && stack.method_7909().method_31568() && !stack.method_31574(ModItems.SCULK_BUNDLE)) {
                int i = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
                if (i == 0) {
                    return 0;
                } else {
                    this.occupancy = this.occupancy.add(OverfilledBundleContentComponent.getOccupancy(stack).multiplyBy(Fraction.getFraction(i, 1)));
                    /*
                    int j = this.addInternal(stack);
                    if (j != -1) {
                        ItemStack itemStack = this.stacks.remove(j);
                        ItemStack itemStack2 = itemStack.copyWithCount(itemStack.getCount() + i);
                        stack.decrement(i);

                        this.stacks.addFirst(itemStack2);
                    } else {
                        this.stacks.addFirst(stack.split(i));
                    }
                     */
                    class_1799 spiltStack = stack.method_7971(i);
                    this.stacks.addFirst(spiltStack);

                    return i;
                }
            } else {
                return 0;
            }
        }

        public void saveAll(class_1657 player) {
            for (int i = 0; i < player.method_31548().method_5439(); i++) {
                class_1799 slotStack = player.method_31548().method_5438(i);
                if (slotStack.method_7960()) continue;
                this.add(slotStack);
            }
            /*if (SculkLatch.isTrinketsLoaded) {
                Optional<TrinketComponent> trinketComponent = TrinketsApi.getTrinketComponent(player);
                if (trinketComponent.isEmpty()) {
                    return;
                } // TODO: when trinkets compat gets reimplemented, make sure to account for a TrinketItem's drop rules
                for (Pair<SlotReference, ItemStack> slotReferenceItemStackPair : trinketComponent.get().getAllEquipped()) {
                    this.add(slotReferenceItemStackPair.getRight());
                }
            }*/
        }

        public void ejectAll(class_1657 player) {
            if (player.method_37908().method_8608() || this.stacks.isEmpty()) return;
            for (class_1799 stack: this.stacks) {

                if (!player.method_31548().method_7394(stack)) {
                    player.method_37908().method_8649(new class_1542(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack));
                }
            }

            this.clear();
        }

        @Nullable
        public class_1799 removeFirst() {
            if (this.stacks.isEmpty()) {
                return null;
            } else {
                class_1799 itemStack = this.stacks.removeFirst().method_7972();
                this.occupancy = this.occupancy.subtract(OverfilledBundleContentComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction(itemStack.method_7947(), 1)));
                return itemStack;
            }
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public OverfilledBundleContentComponent build() {
            return new OverfilledBundleContentComponent(List.copyOf(this.stacks), this.occupancy);
        }
    }
}