package chaos.sculklatch.mixin;

import chaos.sculklatch.items.ModItems;
import chaos.sculklatch.items.custom.SculkBundleItem;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1282;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1542.class)
public abstract class NoSculkBundleDespawnMixin {
    @Shadow
    private int itemAge;

    @Shadow
    public abstract class_1799 getStack();

    @Inject(method = "tick", at = @At("TAIL"))
    public void sculkLatch$preventSculkBundleDespawning(CallbackInfo ci) {
        if (this.getStack().method_7909() instanceof SculkBundleItem) {
            if (this.itemAge >= 5900) {
                this.itemAge = 0;
            }
        }
    }

    @WrapOperation(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/ItemEntity;isAlwaysInvulnerableTo(Lnet/minecraft/entity/damage/DamageSource;)Z"), method = "damage")
    public boolean sculkLatch$sculkBundleDamageImmunity(class_1542 instance, class_1282 source, Operation<Boolean> original) {
        if (instance.method_6983().method_31574(ModItems.SCULK_BUNDLE) && (source.method_48789(class_8103.field_42249) || source.method_49708(class_8111.field_42344))) {
            return true;
        }
        return original.call(instance, source);
    }
}
