package chaos.sculklatch.mixin;

import chaos.sculklatch.items.ModItems;
import chaos.sculklatch.items.custom.components.ModDataComponentTypes;
import chaos.sculklatch.items.custom.components.custom.OverfilledBundleContentComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Mixin(class_3222.class)
public abstract class OnDeathItemSaveMixin {

    @Unique
    private static List<Integer> getSculkBundles(class_1263 inventory) {
        List<Integer> slots = new ArrayList<>();
        for (int j = 0; j < inventory.method_5439(); ++j) {
            class_1799 itemStack = inventory.method_5438(j);
            if (itemStack.method_7909().equals(ModItems.SCULK_BUNDLE)) {
                slots.add(j);
            }
        }
        return slots;
    }

    @Unique
    private static void fillSculkBundles(class_3222 player) {
        int sculk_bundle_count = player.method_31548().method_18861(ModItems.SCULK_BUNDLE);
        if (sculk_bundle_count != 0) {
            List<Integer> sculkBundleSlots = getSculkBundles(player.method_31548());
            for (Integer sculkBundleSlot : sculkBundleSlots) {
                class_1799 sculkBundle = player.method_31548().method_5438(sculkBundleSlot);
                OverfilledBundleContentComponent bundleContentsComponent = sculkBundle.method_58694(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS);
                if (bundleContentsComponent == null) return;
                OverfilledBundleContentComponent.Builder builder = new OverfilledBundleContentComponent.Builder(bundleContentsComponent);
                builder.saveAll(player);
                sculkBundle.method_57379(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS, builder.build());
            }
        }
    }

    @Inject(at = @At("HEAD"), method = "onDeath")
    public void sculkLatch$fillSculkBundlesOnDeath(class_1282 damageSource, CallbackInfo ci) {
        class_3222 entity = (class_3222) (Object) this;
        if (!(entity.method_51469() instanceof class_3218 serverWorld)) {
            return;
        }
        if (!serverWorld.method_64395().method_8355(class_1928.field_19389) && !entity.method_7325()) {
            fillSculkBundles(entity);
        }
    }
}