package chaos.sculklatch.mixin;

import chaos.sculklatch.SculkLatch;
import chaos.sculklatch.blocks.ModBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7125;
import net.minecraft.class_7140;
import net.minecraft.class_7141;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_7140.class)
public abstract class SculkSpreadJawMixin {

    @Shadow
    protected abstract boolean canGenerate(class_1936 world, class_2338 pos);

    @Inject(at = @At("RETURN"), method = "generate")
    public void generate(class_5821<class_7141> context, CallbackInfoReturnable<Boolean> cir) {
        class_2338 blockPos = context.method_33655();
        class_5281 structureWorldAccess = context.method_33652();

        if (this.canGenerate(structureWorldAccess, blockPos)) {
            class_5819 random = context.method_33654();
            for (int i = 0; i < SculkLatch.SCULK_JAW_PLACE_TRIES; ++i) {
                class_2338 blockPos3 = blockPos.method_10069(random.method_43048(5) - 2, 0, random.method_43048(5) - 2);
                if (structureWorldAccess.method_8320(blockPos3).method_26204() instanceof class_7125 && structureWorldAccess.method_8320(blockPos3.method_10084()).method_26215() && structureWorldAccess.method_8320(blockPos3.method_10074()).method_26206(structureWorldAccess, blockPos3.method_10074(), class_2350.field_11036)) {
                    structureWorldAccess.method_8652(blockPos3, ModBlocks.SCULK_JAW.method_9564(), 3);
                    break;
                }
            }
        }
    }
}
