package chaos.sculklatch.mixin;

import chaos.sculklatch.blocks.ModBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7125;
import net.minecraft.class_7128;

import static net.minecraft.class_2281.field_10768;


@Mixin(class_7125.class)
public abstract class SculkSpreadMixin {

    @Unique
    private static final Map<Integer, class_2350> FACING_MAP = new HashMap<>(Map.of(0, class_2350.field_11043, 1, class_2350.field_11034, 2, class_2350.field_11035, 3, class_2350.field_11039));

    @Shadow
    private static int getDecay(class_7128 spreadManager, class_2338 cursorPos, class_2338 catalystPos, int charge) {
        return 0;
    }

    @Shadow
    private static boolean shouldNotDecay(class_1936 world, class_2338 pos) {
        return false;
    }

    @Shadow
    private class_2680 getExtraBlockState(class_1936 world, class_2338 pos, class_5819 random, boolean allowShrieker) {
        return null;
    }



    @Inject(at = @At("HEAD"), method = "spread", cancellable = true)
    public void sculkLatch$spreadSculkJaw(class_7128.class_7129 cursor, class_1936 world, class_2338 catalystPos, class_5819 random, class_7128 spreadManager, boolean shouldConvertToBlock, CallbackInfoReturnable<Integer> cir) {
        int cursorCharge = cursor.method_41508();
        class_2338 blockPos = cursor.method_41495();
        class_2338 raisedBlockPos = blockPos.method_10084();
        //replace chest with sculk chest
        ///tp -1000655.500000 100.000000 -59887.500000
        if (world != null) {
            /*
            for (BlockPos potentialChestPos : BlockPos.iterate(raisedBlockPos.add(1, 0, 1), raisedBlockPos.add(-1, 0, -1))) {
                BlockState chestState = world.getBlockState(potentialChestPos);
                if (chestState.isOf(Blocks.CHEST)) {
                    BlockEntity chestBlockEntity = world.getBlockEntity(potentialChestPos);
                    System.out.println("checking if (chestBlockEntity instanceof ChestBlockEntity)");
                    System.out.println("pos is " + potentialChestPos + " and chestBlockEntity is " + chestBlockEntity);
                    if (chestBlockEntity instanceof ChestBlockEntity) {
                        if (!((ChestBlockEntity) chestBlockEntity).isEmpty()) {

                            List<ItemStack> inventory = new ArrayList<>();
                            System.out.println("pulling items");
                            //Map<ItemStack, Integer> itemStackMap = new HashMap<>(Map.of());
                            for (int slot = 0; slot < ((ChestBlockEntity) chestBlockEntity).size(); slot++) {
                                ItemStack stack = ((ChestBlockEntity) chestBlockEntity).getStack(slot);
                                System.out.println("Storing item: " + stack + " in slot: " + slot);
                                inventory.add(slot, stack);
                                //itemStackMap.put(stack, slot);
                            }

                            System.out.println("clearing chestBlockEntity");
                            ((ChestBlockEntity) chestBlockEntity).clear();
                            BlockState sculkChestBlockState = ModBlocks.SCULK_CHEST.getDefaultState().with(FACING, chestState.get(FACING)).with(WATERLOGGED, chestState.get(WATERLOGGED));
                            world.setBlockState(potentialChestPos, sculkChestBlockState, Block.NOTIFY_ALL);
                            System.out.println("playing a sound");
                            world.playSound(null, blockPos, sculkChestBlockState.getSoundGroup().getPlaceSound(), SoundCategory.BLOCKS, 1.0F, 1.0F);

                            BlockEntity amethystblockEntity = world.getBlockEntity(potentialChestPos);
                            System.out.println("pos is " + potentialChestPos + " and chestBlockEntity is " + amethystblockEntity);
                            if (amethystblockEntity instanceof SculkChestBlockEntity) {
                                System.out.println("is amethyst block entity");
                                for (int i = 0; i < inventory.size() - 1; i++) {
                                    ItemStack itemStack = inventory.get(i);
                                    ((SculkChestBlockEntity) amethystblockEntity).setStack(i, itemStack);

                                    //inventory.forEach((stack) -> ((SculkChestBlockEntity) amethystblockEntity).setStack(slot, stack));
                                }
                                //itemStackMap.forEach((stack, slot) -> ((SculkChestBlockEntity) amethystblockEntity).setStack(slot, stack));
                            }
                        }
                    }
                }
            }
             */
            if (cursorCharge != 0 && random.method_43048(spreadManager.method_41490()) == 0) {
                boolean bl = blockPos.method_19771(catalystPos, spreadManager.method_41489());
                if (!bl && shouldNotDecay(world, blockPos)) {
                    //make sensor, shrieker and sculk jaw spawn.
                    int j = spreadManager.method_41488();
                    if (random.method_43048(j) < cursorCharge) {
                        class_2680 blockState = this.getExtraBlockState(world, raisedBlockPos, random, spreadManager.method_41492());
                        //sculk jaw edit
                        if (random.method_43048(3) == 1) {
                            raisedBlockPos = raisedBlockPos.method_10074();
                            Integer facingIndex = random.method_43048(4);
                            blockState = ModBlocks.SCULK_JAW.method_9564().method_11657(field_10768, FACING_MAP.get(facingIndex));
                        }
                        world.method_8652(raisedBlockPos, blockState, class_2248.field_31036);
                        if (blockState != null) {
                            world.method_8396(null, blockPos, blockState.method_26231().method_10598(), class_3419.field_15245, 1.0F, 1.0F);
                        }
                    }

                    cir.setReturnValue(Math.max(0, cursorCharge - j));
                } else {
                    cir.setReturnValue(random.method_43048(spreadManager.method_41491()) != 0 ? cursorCharge : cursorCharge - (bl ? 1 : getDecay(spreadManager, blockPos, catalystPos, cursorCharge)));
                }
            } else {
                cir.setReturnValue(cursorCharge);
            }
            cir.cancel();
        }
    }
}
