/*
 * Decompiled with CFR 0.152.
 */
package chaos.sculklatch.items.custom.components.custom;

import chaos.sculklatch.SculkLatch;
import chaos.sculklatch.items.ModItems;
import chaos.sculklatch.items.custom.components.ModDataComponentTypes;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10706;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class OverfilledBundleContentComponent
implements class_5632 {
    public static final OverfilledBundleContentComponent DEFAULT = new OverfilledBundleContentComponent(List.of());
    public static final Codec<OverfilledBundleContentComponent> CODEC = class_1799.field_24671.listOf().xmap(OverfilledBundleContentComponent::new, component -> component.stacks);
    public static final class_9139<class_9129, OverfilledBundleContentComponent> PACKET_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(OverfilledBundleContentComponent::new, component -> component.stacks);
    private static final Fraction NESTED_BUNDLE_OCCUPANCY = Fraction.getFraction((int)1, (int)32);
    private static final int MAX_ITEMS = 32;
    final List<class_1799> stacks;
    final Fraction occupancy;

    OverfilledBundleContentComponent(List<class_1799> stacks, Fraction occupancy) {
        this.stacks = stacks;
        this.occupancy = occupancy;
    }

    public OverfilledBundleContentComponent(List<class_1799> stacks) {
        this(stacks, OverfilledBundleContentComponent.calculateOccupancy(stacks));
    }

    private static Fraction calculateOccupancy(List<class_1799> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (class_1799 itemStack : stacks) {
            fraction = fraction.add(OverfilledBundleContentComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
        }
        return fraction;
    }

    static Fraction getOccupancy(class_1799 stack) {
        OverfilledBundleContentComponent overfilledBundleContentsComponent = (OverfilledBundleContentComponent)stack.method_58694(ModDataComponentTypes.OVERFILLED_BUNDLE_CONTENTS);
        if (overfilledBundleContentsComponent != null) {
            return NESTED_BUNDLE_OCCUPANCY.add(overfilledBundleContentsComponent.getOccupancy());
        }
        List list = ((class_10706)stack.method_58695(class_9334.field_49624, (Object)class_10706.field_56300)).comp_3585();
        return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction((int)1, (int)(stack.method_7914() * 10));
    }

    public class_1799 get(int index) {
        return this.stacks.get(index);
    }

    public Stream<class_1799> stream() {
        return this.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return this.stacks;
    }

    public Iterable<class_1799> iterateCopy() {
        return Lists.transform(this.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.stacks.size();
    }

    public Fraction getOccupancy() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OverfilledBundleContentComponent)) {
            return false;
        }
        OverfilledBundleContentComponent bundleContentsComponent = (OverfilledBundleContentComponent)o;
        return this.occupancy.equals((Object)bundleContentsComponent.occupancy) && class_1799.method_57362(this.stacks, bundleContentsComponent.stacks);
    }

    public int hashCode() {
        return class_1799.method_57361(this.stacks);
    }

    public String toString() {
        return "OverFilledBundleContents" + String.valueOf(this.stacks);
    }

    public static class Builder {
        private final List<class_1799> stacks;
        private Fraction occupancy;

        public Builder(OverfilledBundleContentComponent base) {
            this.stacks = new ArrayList<class_1799>(base.stacks);
            this.occupancy = base.occupancy;
        }

        public Builder clear() {
            this.stacks.clear();
            this.occupancy = Fraction.ZERO;
            return this;
        }

        private int addInternal(class_1799 stack) {
            if (stack.method_7946()) {
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (!class_1799.method_31577((class_1799)this.stacks.get(i), (class_1799)stack)) continue;
                    return i;
                }
            }
            return -1;
        }

        private int getMaxAllowed(class_1799 stack) {
            Fraction fraction = Fraction.ONE.subtract(this.occupancy);
            return Math.max(fraction.divideBy(OverfilledBundleContentComponent.getOccupancy(stack)).intValue(), 0);
        }

        private int add(class_1799 stack) {
            if (!stack.method_7960() && stack.method_7909().method_31568() && !stack.method_31574(ModItems.SCULK_BUNDLE)) {
                int i = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
                if (i == 0) {
                    return 0;
                }
                this.occupancy = this.occupancy.add(OverfilledBundleContentComponent.getOccupancy(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                class_1799 spiltStack = stack.method_7971(i);
                this.stacks.addFirst(spiltStack);
                return i;
            }
            return 0;
        }

        public void saveAll(class_1657 player) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 slotStack = player.method_31548().method_5438(i);
                if (slotStack.method_7960()) continue;
                itemStacks.add(slotStack);
            }
            if (SculkLatch.isTrinketsLoaded) {
                Optional trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player);
                if (trinketComponent.isEmpty()) {
                    return;
                }
                for (class_3545 slotReferenceItemStackPair : ((TrinketComponent)trinketComponent.get()).getAllEquipped()) {
                    itemStacks.add((class_1799)slotReferenceItemStackPair.method_15441());
                }
            }
            itemStacks.sort(Comparator.comparing(stack -> stack.method_7932().ordinal() - 3));
            itemStacks.sort((stack, stack2) -> stack.method_7964() != stack.method_63693() ? 1 : (stack2.method_7964() != stack2.method_63693() ? -1 : 0));
            itemStacks.sort(Comparator.comparingInt(stack -> stack.method_58657().method_57534().size()));
            for (class_1799 itemStack : itemStacks.reversed()) {
                this.add(itemStack);
            }
        }

        public void ejectAll(class_1657 player) {
            if (player.method_73183().method_8608() || this.stacks.isEmpty()) {
                return;
            }
            for (class_1799 stack : this.stacks) {
                if (player.method_31548().method_7394(stack)) continue;
                player.method_73183().method_8649((class_1297)new class_1542(player.method_73183(), player.method_23317(), player.method_23318(), player.method_23321(), stack));
            }
            this.clear();
        }

        @Nullable
        public class_1799 removeFirst() {
            if (this.stacks.isEmpty()) {
                return null;
            }
            class_1799 itemStack = this.stacks.removeFirst().method_7972();
            this.occupancy = this.occupancy.subtract(OverfilledBundleContentComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction((int)itemStack.method_7947(), (int)1)));
            return itemStack;
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public OverfilledBundleContentComponent build() {
            return new OverfilledBundleContentComponent(List.copyOf(this.stacks), this.occupancy);
        }
    }
}

