/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.hostile_neural_industrialization.common.util;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTierRegistry;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.luligabi.hostile_neural_industrialization.common.HNI;
import me.luligabi.hostile_neural_industrialization.mixin.DataModelRegistryAccessor;
import me.luligabi.hostile_neural_industrialization.mixin.ModelTierRegistryAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a~\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0018\u00010\n*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\f\u001a4\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\fH\u0002\u001a\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0006\u0010 \u001a\u00020\u001f\u001a\u0006\u0010!\u001a\u00020\u001f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\""}, d2={"electricSimChamberCost", "", "Ldev/shadowsoffire/hostilenetworks/data/DataModel;", "getElectricSimChamberCost", "(Ldev/shadowsoffire/hostilenetworks/data/DataModel;)I", "largeSimChamberCost", "getLargeSimChamberCost", "largeLootFabricatorCost", "getLargeLootFabricatorCost", "getDimensionFluid", "Lkotlin/Triple;", "Lnet/minecraft/world/level/material/Fluid;", "", "overworldFluid", "", "overworldAmount", "overworldProbability", "netherFluid", "netherAmount", "netherProbability", "theEndFluid", "theEndAmount", "theEndProbability", "twilightFluid", "twilightAmount", "twilightProbability", "parseFluid", "fluidId", "amount", "probability", "isHNNRegistryLoaded", "", "isTierRegistryLoaded", "isModelRegistryLoaded", "hostile_neural_industrialization"})
public final class DataModelUtilKt {
    public static final int getElectricSimChamberCost(@NotNull DataModel $this$electricSimChamberCost) {
        Intrinsics.checkNotNullParameter((Object)$this$electricSimChamberCost, (String)"<this>");
        return (int)((double)$this$electricSimChamberCost.simCost() * HNI.Companion.getCONFIG().electricSimChamber().energyMultiplier());
    }

    public static final int getLargeSimChamberCost(@NotNull DataModel $this$largeSimChamberCost) {
        Intrinsics.checkNotNullParameter((Object)$this$largeSimChamberCost, (String)"<this>");
        return (int)((double)$this$largeSimChamberCost.simCost() * HNI.Companion.getCONFIG().largeSimChamber().energyMultiplier());
    }

    public static final int getLargeLootFabricatorCost(@NotNull DataModel $this$largeLootFabricatorCost) {
        Intrinsics.checkNotNullParameter((Object)$this$largeLootFabricatorCost, (String)"<this>");
        return (int)((double)$this$largeLootFabricatorCost.simCost() * HNI.Companion.getCONFIG().largeLootFabricator().energyMultiplier());
    }

    @Nullable
    public static final Triple<Fluid, Integer, Float> getDimensionFluid(@NotNull DataModel $this$getDimensionFluid, @NotNull String overworldFluid, int overworldAmount, float overworldProbability, @NotNull String netherFluid, int netherAmount, float netherProbability, @NotNull String theEndFluid, int theEndAmount, float theEndProbability, @NotNull String twilightFluid, int twilightAmount, float twilightProbability) {
        Intrinsics.checkNotNullParameter((Object)$this$getDimensionFluid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)overworldFluid, (String)"overworldFluid");
        Intrinsics.checkNotNullParameter((Object)netherFluid, (String)"netherFluid");
        Intrinsics.checkNotNullParameter((Object)theEndFluid, (String)"theEndFluid");
        Intrinsics.checkNotNullParameter((Object)twilightFluid, (String)"twilightFluid");
        if (StringsKt.isBlank((CharSequence)overworldFluid) && StringsKt.isBlank((CharSequence)netherFluid) && StringsKt.isBlank((CharSequence)theEndFluid) && StringsKt.isBlank((CharSequence)twilightFluid)) {
            return null;
        }
        return $this$getDimensionFluid.baseDrop().is(Hostile.Items.OVERWORLD_PREDICTION) ? DataModelUtilKt.parseFluid(overworldFluid, overworldAmount, overworldProbability) : ($this$getDimensionFluid.baseDrop().is(Hostile.Items.NETHER_PREDICTION) ? DataModelUtilKt.parseFluid(netherFluid, netherAmount, netherProbability) : ($this$getDimensionFluid.baseDrop().is(Hostile.Items.END_PREDICTION) ? DataModelUtilKt.parseFluid(theEndFluid, theEndAmount, theEndProbability) : ($this$getDimensionFluid.baseDrop().is(Hostile.Items.TWILIGHT_PREDICTION) ? DataModelUtilKt.parseFluid(twilightFluid, twilightAmount, twilightProbability) : null)));
    }

    private static final Triple<Fluid, Integer, Float> parseFluid(String fluidId, int amount, float probability) {
        if (StringsKt.isBlank((CharSequence)fluidId)) {
            return null;
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)fluidId);
        if (resourceLocation == null) {
            return null;
        }
        ResourceLocation id = resourceLocation;
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceKey.create((ResourceKey)BuiltInRegistries.FLUID.key(), (ResourceLocation)id));
        if (fluid == null) {
            return null;
        }
        return new Triple((Object)fluid, (Object)amount, (Object)Float.valueOf(probability));
    }

    public static final boolean isHNNRegistryLoaded() {
        return DataModelUtilKt.isTierRegistryLoaded() && DataModelUtilKt.isModelRegistryLoaded();
    }

    public static final boolean isTierRegistryLoaded() {
        ModelTierRegistry modelTierRegistry = ModelTierRegistry.INSTANCE;
        Intrinsics.checkNotNull((Object)modelTierRegistry, (String)"null cannot be cast to non-null type me.luligabi.hostile_neural_industrialization.mixin.ModelTierRegistryAccessor");
        return !((ModelTierRegistryAccessor)modelTierRegistry).getSorted().isEmpty();
    }

    public static final boolean isModelRegistryLoaded() {
        DataModelRegistry dataModelRegistry = DataModelRegistry.INSTANCE;
        Intrinsics.checkNotNull((Object)dataModelRegistry, (String)"null cannot be cast to non-null type me.luligabi.hostile_neural_industrialization.mixin.DataModelRegistryAccessor");
        return !((DataModelRegistryAccessor)dataModelRegistry).getModelsByType().isEmpty();
    }
}

