import os
import json

def replace_in_json_files():
    folder = os.getcwd()  # Get the current directory
    
    for filename in os.listdir(folder):
        if filename.endswith(".json"):
            old_path = os.path.join(folder, filename)
            new_filename = filename.replace("jellie", "persian").replace("Jellie", "Persian")
            new_path = os.path.join(folder, new_filename)
            
            with open(old_path, "r", encoding="utf-8") as file:
                try:
                    data = json.load(file)
                except json.JSONDecodeError:
                    print(f"Skipping {filename}: Invalid JSON format.")
                    continue
                
                json_str = json.dumps(data)
                updated_json_str = json_str.replace("jellie", "persian").replace("Jellie", "Persian")
                updated_data = json.loads(updated_json_str)
            
            with open(new_path, "w", encoding="utf-8") as file:
                json.dump(updated_data, file, indent=4)
            
            if old_path != new_path:
                os.remove(old_path)
                print(f"Renamed {filename} -> {new_filename} and replaced occurrences inside the file.")
            else:
                print(f"Updated content in {filename} without renaming.")

if __name__ == "__main__":
    replace_in_json_files()
