import os

def main():
    # Get the folder where the script is located
    folder = os.path.dirname(os.path.abspath(__file__))

    for filename in os.listdir(folder):
        if filename.endswith(".json"):
            filepath = os.path.join(folder, filename)

            # Case 1: Delete file if "16b" in filename
            if "16b" in filename:
                print(f"Deleting: {filename}")
                os.remove(filepath)

            # Case 2: Replace "16b" with "15b" inside file if "showline" in filename
            elif "showline" in filename:
                print(f"Editing: {filename}")
                with open(filepath, "r", encoding="utf-8") as f:
                    content = f.read()

                new_content = content.replace("16b", "15b")

                with open(filepath, "w", encoding="utf-8") as f:
                    f.write(new_content)

if __name__ == "__main__":
    main()
