/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa;

import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import top.craft_hello.tpa.commands.Back;
import top.craft_hello.tpa.commands.DelHome;
import top.craft_hello.tpa.commands.DelSpawn;
import top.craft_hello.tpa.commands.DelWarp;
import top.craft_hello.tpa.commands.Denys;
import top.craft_hello.tpa.commands.Home;
import top.craft_hello.tpa.commands.Homes;
import top.craft_hello.tpa.commands.Rtp;
import top.craft_hello.tpa.commands.SetDefaultHome;
import top.craft_hello.tpa.commands.SetHome;
import top.craft_hello.tpa.commands.SetSpawn;
import top.craft_hello.tpa.commands.SetWarp;
import top.craft_hello.tpa.commands.Spawn;
import top.craft_hello.tpa.commands.TpAccept;
import top.craft_hello.tpa.commands.TpAll;
import top.craft_hello.tpa.commands.TpDeny;
import top.craft_hello.tpa.commands.TpHere;
import top.craft_hello.tpa.commands.TpLogout;
import top.craft_hello.tpa.commands.Tpa;
import top.craft_hello.tpa.commands.Warp;
import top.craft_hello.tpa.events.TPAPlayerDeathEvent;
import top.craft_hello.tpa.events.TPAPlayerJoinEvent;
import top.craft_hello.tpa.events.TPAPlayerLocaleChangeEvent;
import top.craft_hello.tpa.events.TPAPlayerQuitEvent;
import top.craft_hello.tpa.events.TPAPlayerRespawnEvent;
import top.craft_hello.tpa.events.TPAPlayerTeleportEvent;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.other.org.bstats.bukkit.Metrics;
import top.craft_hello.tpa.tabcompleters.DenysTabCompleter;
import top.craft_hello.tpa.tabcompleters.EmptyListTabCompleter;
import top.craft_hello.tpa.tabcompleters.HomeTabCompleter;
import top.craft_hello.tpa.tabcompleters.SetDefaultHomeTabCompleter;
import top.craft_hello.tpa.tabcompleters.TpAllTabCompleter;
import top.craft_hello.tpa.tabcompleters.TpHereTabCompleter;
import top.craft_hello.tpa.tabcompleters.TpLogoutTabCompleter;
import top.craft_hello.tpa.tabcompleters.TpaTabCompleter;
import top.craft_hello.tpa.tabcompleters.WarpTabCompleter;
import top.craft_hello.tpa.utils.ErrorCheckUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;
import top.craft_hello.tpa.utils.VersionUtil;

public final class TPA
extends JavaPlugin {
    private final CommandSender CONSOLE = this.getServer().getConsoleSender();
    private final PluginManager PLUGIN_MANAGER = this.getServer().getPluginManager();

    public void onEnable() {
        int pluginId = 26417;
        Metrics metrics = new Metrics(this, pluginId);
        HandySchedulerUtil.init((Plugin)this);
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            LoadingConfigUtil.init((Plugin)this);
            VersionUtil.init((Plugin)this);
            this.registerCommands();
            this.registerEvents();
            SendMessageUtil.pluginLoaded(this.CONSOLE, VersionUtil.getPluginVersion());
            if (LoadingConfigUtil.getConfig().isUpdateCheck()) {
                ErrorCheckUtil.executeCommand(this.CONSOLE, null, "version");
            }
        });
    }

    public void onDisable() {
        SendMessageUtil.pluginUnLoaded(this.CONSOLE);
    }

    public void registerCommands() {
        Objects.requireNonNull(this.getCommand("tpa")).setExecutor((CommandExecutor)new Tpa());
        Objects.requireNonNull(this.getCommand("tphere")).setExecutor((CommandExecutor)new TpHere());
        Objects.requireNonNull(this.getCommand("tpall")).setExecutor((CommandExecutor)new TpAll());
        Objects.requireNonNull(this.getCommand("rtp")).setExecutor((CommandExecutor)new Rtp());
        Objects.requireNonNull(this.getCommand("tplogout")).setExecutor((CommandExecutor)new TpLogout());
        Objects.requireNonNull(this.getCommand("tpaccept")).setExecutor((CommandExecutor)new TpAccept());
        Objects.requireNonNull(this.getCommand("tpdeny")).setExecutor((CommandExecutor)new TpDeny());
        Objects.requireNonNull(this.getCommand("denys")).setExecutor((CommandExecutor)new Denys());
        Objects.requireNonNull(this.getCommand("warp")).setExecutor((CommandExecutor)new Warp());
        Objects.requireNonNull(this.getCommand("setwarp")).setExecutor((CommandExecutor)new SetWarp());
        Objects.requireNonNull(this.getCommand("delwarp")).setExecutor((CommandExecutor)new DelWarp());
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)new Home());
        Objects.requireNonNull(this.getCommand("homes")).setExecutor((CommandExecutor)new Homes());
        Objects.requireNonNull(this.getCommand("sethome")).setExecutor((CommandExecutor)new SetHome());
        Objects.requireNonNull(this.getCommand("setdefaulthome")).setExecutor((CommandExecutor)new SetDefaultHome());
        Objects.requireNonNull(this.getCommand("delhome")).setExecutor((CommandExecutor)new DelHome());
        Objects.requireNonNull(this.getCommand("spawn")).setExecutor((CommandExecutor)new Spawn());
        Objects.requireNonNull(this.getCommand("setspawn")).setExecutor((CommandExecutor)new SetSpawn());
        Objects.requireNonNull(this.getCommand("delspawn")).setExecutor((CommandExecutor)new DelSpawn());
        Objects.requireNonNull(this.getCommand("back")).setExecutor((CommandExecutor)new Back());
        Objects.requireNonNull(this.getCommand("tpa")).setTabCompleter((TabCompleter)new TpaTabCompleter());
        Objects.requireNonNull(this.getCommand("tphere")).setTabCompleter((TabCompleter)new TpHereTabCompleter());
        Objects.requireNonNull(this.getCommand("tpall")).setTabCompleter((TabCompleter)new TpAllTabCompleter());
        Objects.requireNonNull(this.getCommand("rtp")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("tplogout")).setTabCompleter((TabCompleter)new TpLogoutTabCompleter());
        Objects.requireNonNull(this.getCommand("tpaccept")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("tpdeny")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("denys")).setTabCompleter((TabCompleter)new DenysTabCompleter());
        Objects.requireNonNull(this.getCommand("warp")).setTabCompleter((TabCompleter)new WarpTabCompleter());
        Objects.requireNonNull(this.getCommand("setwarp")).setTabCompleter((TabCompleter)new WarpTabCompleter());
        Objects.requireNonNull(this.getCommand("delwarp")).setTabCompleter((TabCompleter)new WarpTabCompleter());
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("homes")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("sethome")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("setdefaulthome")).setTabCompleter((TabCompleter)new SetDefaultHomeTabCompleter());
        Objects.requireNonNull(this.getCommand("delhome")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("spawn")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("setspawn")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("delspawn")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
        Objects.requireNonNull(this.getCommand("back")).setTabCompleter((TabCompleter)new EmptyListTabCompleter());
    }

    public void registerEvents() {
        this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerJoinEvent(), (Plugin)this);
        this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerQuitEvent(), (Plugin)this);
        this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerDeathEvent(), (Plugin)this);
        this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerRespawnEvent(), (Plugin)this);
        this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerTeleportEvent(), (Plugin)this);
        if (!LoadingConfigUtil.getConfig().isOldServer()) {
            this.PLUGIN_MANAGER.registerEvents((Listener)new TPAPlayerLocaleChangeEvent(), (Plugin)this);
        }
    }
}

