/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.abstracts;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import top.craft_hello.tpa.abstracts.ErrorException;
import top.craft_hello.tpa.interfaces.ConfigurationInterface;
import top.craft_hello.tpa.objects.Config;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;
import top.craft_hello.tpa.utils.VersionUtil;

public abstract class Configuration
implements ConfigurationInterface {
    protected static String configVersion;
    protected static boolean updateConfiguration;
    protected static final Plugin PLUGIN;
    protected static final String VERSION;
    protected static final String SERVER_VERSION;
    protected String languageStr;
    protected File configurationFile;
    protected FileConfiguration configuration;

    public static String formatLangStr(String languageStr) {
        Config config = LoadingConfigUtil.getConfig();
        if (Objects.isNull(config)) {
            if (Objects.isNull(languageStr)) {
                languageStr = PLUGIN.getConfig().getString("lang");
            }
            if (Objects.isNull(languageStr)) {
                languageStr = PLUGIN.getConfig().getString("language");
            }
            if (Objects.isNull(languageStr)) {
                languageStr = "zh_CN";
            }
        } else if (Objects.isNull(languageStr)) {
            languageStr = config.getDefaultLanguageStr();
        }
        if (languageStr.matches("^[a-zA-Z]{2}_[a-zA-Z]{2}$")) {
            languageStr = languageStr.toLowerCase();
            String langStr2 = languageStr.substring(0, languageStr.indexOf("_"));
            String langStr3 = languageStr.substring(languageStr.indexOf("_")).toUpperCase();
            return langStr2 + langStr3;
        }
        return "zh_CN";
    }

    protected void loadConfiguration(boolean isReplace) {
        if (isReplace || !this.configurationFile.exists()) {
            PLUGIN.saveResource(this.configurationFile.getName(), isReplace);
            this.configurationFile = new File(this.configurationFile.getAbsolutePath());
        }
        try {
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(this.configurationFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            this.configuration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveConfiguration(CommandSender sender) {
        ErrorException.trySaveConfiguration(sender, this.configuration, this.configurationFile);
        this.reloadConfiguration();
    }

    protected Location loadLocation(String index) {
        String worldName = this.configuration.getString(index + ".world");
        if (Objects.isNull(worldName)) {
            return null;
        }
        World world = Bukkit.getWorld((String)worldName);
        double x = this.configuration.getDouble(index + ".x");
        double y = this.configuration.getDouble(index + ".y");
        double z = this.configuration.getDouble(index + ".z");
        float pitch = (float)this.configuration.getDouble(index + ".pitch");
        float yaw = (float)this.configuration.getDouble(index + ".yaw");
        return new Location(world, x, y, z, yaw, pitch);
    }

    protected void setLocation(String index, Location location) {
        if (Objects.isNull(location)) {
            return;
        }
        this.configuration.set(index + ".world", (Object)location.getWorld().getName());
        this.configuration.set(index + ".x", (Object)location.getX());
        this.configuration.set(index + ".y", (Object)location.getY());
        this.configuration.set(index + ".z", (Object)location.getZ());
        this.configuration.set(index + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.configuration.set(index + ".yaw", (Object)Float.valueOf(location.getYaw()));
    }

    public static void configVersionCheck() {
        PLUGIN.reloadConfig();
        configVersion = PLUGIN.getConfig().getString("version");
        String string = configVersion = Objects.isNull(configVersion) ? "1.0" : configVersion;
        if (VersionUtil.versionComparison(configVersion, VERSION)) {
            Configuration.onUpdateConfiguration();
        }
    }

    private static void onUpdateConfiguration() {
        if (Objects.isNull(configVersion)) {
            return;
        }
        updateConfiguration = true;
    }

    public static void offUpdateConfiguration() {
        if (updateConfiguration) {
            updateConfiguration = false;
            PLUGIN.reloadConfig();
            SendMessageUtil.configVersionUpdateSuccess((CommandSender)Bukkit.getConsoleSender());
        }
    }

    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    static {
        updateConfiguration = false;
        PLUGIN = LoadingConfigUtil.getPlugin();
        VERSION = PLUGIN.getDescription().getVersion();
        SERVER_VERSION = PLUGIN.getServer().getVersion().substring(PLUGIN.getServer().getVersion().indexOf("(MC: 1.")).replaceAll("\\)", "").replaceAll("\\(MC: ", "");
    }
}

