/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.abstracts;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import top.craft_hello.tpa.exceptions.ErrorConfigNotFoundException;
import top.craft_hello.tpa.exceptions.ErrorRuntimeException;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public abstract class ErrorException
extends RuntimeException {
    protected final LanguageConfig LANGUAGE;
    protected final CommandSender SEND_TARGET;
    protected final String MESSAGE_INDEX;
    protected final String[] VARS;

    public ErrorException(CommandSender sendTarget, String messageIndex, String ... vars) {
        this.LANGUAGE = LanguageConfig.getLanguage(sendTarget);
        this.SEND_TARGET = sendTarget;
        this.MESSAGE_INDEX = messageIndex;
        this.VARS = vars;
        this.sendErrorMessage();
    }

    public void sendErrorMessage() {
        SendMessageUtil.sendMessage(this.SEND_TARGET, this.LANGUAGE.getFormatPrefixMessage(this.SEND_TARGET, this.MESSAGE_INDEX, this.VARS));
    }

    @Override
    public void printStackTrace() {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        String target = this.SEND_TARGET instanceof Player ? this.SEND_TARGET.getName() : "Console";
        SendMessageUtil.sendMessage((CommandSender)console, LanguageConfig.getLanguage().getFormatPrefixMessage("error.forwarded_error", target));
        SendMessageUtil.sendMessage((CommandSender)console, LanguageConfig.getLanguage().getFormatPrefixMessage(this.MESSAGE_INDEX, this.VARS));
    }

    public static void catchException(Exception exception) {
        if (LoadingConfigUtil.getConfig().isDebug()) {
            exception.printStackTrace();
        }
    }

    public static boolean trySaveConfiguration(CommandSender sender, FileConfiguration config, File configFile) {
        try {
            config.save(configFile);
            return true;
        }
        catch (IOException ignored) {
            ErrorException.catchException(new ErrorConfigNotFoundException(sender));
            return false;
        }
    }

    public static void tryCreateConfiguration(CommandSender sender, File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
        }
        catch (IOException ignored) {
            ErrorException.catchException(new ErrorRuntimeException(sender, "\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u7684\u65f6\u5019\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\uff08https://github.com/WarSkyGod/TPA/issues\uff09"));
        }
    }
}

