/*
 * Decompiled with CFR 0.152.
 */
package top.craft_hello.tpa.abstracts;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import top.craft_hello.tpa.abstracts.Request;
import top.craft_hello.tpa.enums.CommandType;
import top.craft_hello.tpa.enums.PermissionType;
import top.craft_hello.tpa.exceptions.ErrorCommandCooldownException;
import top.craft_hello.tpa.exceptions.ErrorCommandDisabledException;
import top.craft_hello.tpa.exceptions.ErrorConsoleRestrictedException;
import top.craft_hello.tpa.exceptions.ErrorNoPendingRequestException;
import top.craft_hello.tpa.exceptions.ErrorPermissionDeniedException;
import top.craft_hello.tpa.exceptions.ErrorRequestPendingException;
import top.craft_hello.tpa.exceptions.ErrorRuntimeException;
import top.craft_hello.tpa.exceptions.ErrorSpawnNotSetException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxHomeException;
import top.craft_hello.tpa.exceptions.ErrorSyntaxWarpException;
import top.craft_hello.tpa.exceptions.ErrorTargetOfflineException;
import top.craft_hello.tpa.exceptions.ErrorWarpNotFoundException;
import top.craft_hello.tpa.exceptions.ErrorWorldDisabledException;
import top.craft_hello.tpa.exceptions.RtpFailedException;
import top.craft_hello.tpa.objects.Config;
import top.craft_hello.tpa.objects.LanguageConfig;
import top.craft_hello.tpa.objects.PlayerDataConfig;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandyRunnable;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.HandySchedulerUtil;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.PlayerSchedulerUtil;
import top.craft_hello.tpa.other.cn.handyplus.lib.adapter.FoliaLib.WorldSchedulerUtil;
import top.craft_hello.tpa.utils.LoadingConfigUtil;
import top.craft_hello.tpa.utils.SendMessageUtil;

public abstract class PlayerToLocationRequest
extends Request {
    protected Player requestPlayer;
    protected String requestPlayerName;
    protected String targetName;
    protected CommandType commandType;

    public PlayerToLocationRequest(CommandSender requestObject, String[] args, CommandType commandType) {
        this.commandType = commandType;
        this.checkError(requestObject, args);
        if (!LoadingConfigUtil.getConfig().isEnableTeleportDelay((CommandSender)this.requestPlayer)) {
            this.teleport();
            return;
        }
        this.setCheckMoveTimer(this.requestPlayer.getLocation());
        this.setCountdownMessageTimer(this.requestPlayer, this.targetName);
        this.setTimer(this.delay < 0L ? 3000L : this.delay * 1000L);
        REQUEST_QUEUE.put(this.requestPlayer, this);
    }

    protected void checkError() {
        if (Objects.isNull(this.requestPlayer) || !this.requestPlayer.isOnline()) {
            throw new ErrorTargetOfflineException((CommandSender)this.requestPlayer, "null");
        }
    }

    protected void checkError(CommandSender requestObject, String[] args) {
        Config config = LoadingConfigUtil.getConfig();
        switch (this.commandType) {
            case WARP: {
                String command = "warp";
                if (!(requestObject instanceof Player)) {
                    throw new ErrorConsoleRestrictedException(requestObject);
                }
                this.requestPlayer = (Player)requestObject;
                this.requestPlayerName = this.requestPlayer.getName();
                this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
                if (!config.isEnableCommand(this.commandType)) {
                    throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
                }
                if (!config.hasPermission((CommandSender)this.requestPlayer, PermissionType.WARP)) {
                    throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
                }
                if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
                }
                if (REQUEST_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
                }
                if (args.length > 1) {
                    throw new ErrorSyntaxWarpException((CommandSender)this.requestPlayer, command);
                }
                this.targetName = args[args.length - 1];
                if (!LoadingConfigUtil.getWarpConfig().containsWarpLocation(this.targetName)) {
                    throw new ErrorWarpNotFoundException((CommandSender)this.requestPlayer, this.targetName);
                }
                this.location = LoadingConfigUtil.getWarpConfig().getWarpLocation((CommandSender)this.requestPlayer, this.targetName);
                break;
            }
            case HOME: {
                String command = "home";
                if (!(requestObject instanceof Player)) {
                    throw new ErrorConsoleRestrictedException(requestObject);
                }
                this.requestPlayer = (Player)requestObject;
                this.requestPlayerName = this.requestPlayer.getName();
                this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
                if (!config.isEnableCommand(this.commandType)) {
                    throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
                }
                if (!config.hasPermission((CommandSender)this.requestPlayer, PermissionType.HOME)) {
                    throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
                }
                if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
                }
                if (REQUEST_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
                }
                if (args.length > 1) {
                    throw new ErrorSyntaxHomeException((CommandSender)this.requestPlayer, command);
                }
                PlayerDataConfig playerDataConfig = PlayerDataConfig.getPlayerData(this.requestPlayer);
                if (args.length == 0) {
                    this.location = playerDataConfig.getHomeLocation();
                    this.targetName = playerDataConfig.getDefaultHomeName();
                    break;
                }
                this.targetName = args[args.length - 1];
                this.location = PlayerDataConfig.getPlayerData(this.requestPlayer).getHomeLocation(this.targetName);
                break;
            }
            case SPAWN: {
                if (!(requestObject instanceof Player)) {
                    throw new ErrorConsoleRestrictedException(requestObject);
                }
                this.requestPlayer = (Player)requestObject;
                this.requestPlayerName = this.requestPlayer.getName();
                this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
                if (!config.isEnableCommand(this.commandType)) {
                    throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
                }
                if (!config.hasPermission((CommandSender)this.requestPlayer, PermissionType.SPAWN)) {
                    throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
                }
                if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
                }
                if (REQUEST_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
                }
                if (!LoadingConfigUtil.getSpawnConfig().containsSpawnLocation()) {
                    throw new ErrorSpawnNotSetException((CommandSender)this.requestPlayer);
                }
                this.location = LoadingConfigUtil.getSpawnConfig().getSpawnLocation((CommandSender)this.requestPlayer);
                this.targetName = "spawn_name";
                break;
            }
            case BACK: {
                if (!(requestObject instanceof Player)) {
                    throw new ErrorConsoleRestrictedException(requestObject);
                }
                this.requestPlayer = (Player)requestObject;
                this.requestPlayerName = this.requestPlayer.getName();
                this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
                if (!config.isEnableCommand(this.commandType)) {
                    throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
                }
                if (!config.hasPermission((CommandSender)this.requestPlayer, PermissionType.BACK)) {
                    throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
                }
                if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
                }
                if (REQUEST_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
                }
                this.location = PlayerDataConfig.getPlayerData(this.requestPlayer).getLastLocation();
                this.targetName = "last_location";
                break;
            }
            case RTP: {
                random.setSeed(System.currentTimeMillis());
                if (!(requestObject instanceof Player)) {
                    throw new ErrorConsoleRestrictedException(requestObject);
                }
                this.requestPlayer = (Player)requestObject;
                this.requestPlayerName = this.requestPlayer.getName();
                this.delay = LoadingConfigUtil.getConfig().getTeleportDelay((CommandSender)this.requestPlayer);
                if (!config.isEnableCommand(this.commandType)) {
                    throw new ErrorCommandDisabledException((CommandSender)this.requestPlayer);
                }
                if (!config.hasPermission((CommandSender)this.requestPlayer, PermissionType.RTP)) {
                    throw new ErrorPermissionDeniedException((CommandSender)this.requestPlayer);
                }
                if (COMMAND_DELAY_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorCommandCooldownException((CommandSender)this.requestPlayer, (String)COMMAND_DELAY_QUEUE.get(this.requestPlayer));
                }
                if (REQUEST_QUEUE.containsKey(this.requestPlayer)) {
                    throw new ErrorRequestPendingException((CommandSender)this.requestPlayer);
                }
                this.targetName = "rtp_name";
                World world = this.requestPlayer.getWorld();
                if (config.isRtpDisableWorld(world)) {
                    throw new ErrorWorldDisabledException((CommandSender)this.requestPlayer);
                }
                SendMessageUtil.generateRandomLocationMessage(this.requestPlayer);
                if (config.isEnableTitleMessage()) {
                    SendMessageUtil.titleGenerateRandomLocationMessage(this.requestPlayer);
                    if (config.isEnableSound()) {
                        PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                }
                this.location = this.requestPlayer.getLocation();
                int limitX = config.getRtpLimitX();
                int limitZ = config.getRtpLimitZ();
                double x = random.nextDouble(this.location.getX() - (double)limitX, this.location.getX() + (double)limitX);
                double z = random.nextDouble(this.location.getZ() - (double)limitZ, this.location.getZ() + (double)limitZ);
                this.location.setX(x);
                this.location.setZ(z);
                WorldSchedulerUtil.getChunkAtAsync(this.location);
                int y = world.getHighestBlockYAt((int)this.location.getX(), (int)this.location.getZ(), HeightMap.WORLD_SURFACE);
                this.location.setY((double)y);
                break;
            }
            default: {
                throw new ErrorRuntimeException(requestObject, "\u5728 objects.PlayerToLocationRequest : 35\u884c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\uff08https://github.com/WarSkyGod/TPA/issues\uff09");
            }
        }
    }

    protected void setTimer(long delay) {
        HandyRunnable timer;
        this.timer = timer = new HandyRunnable(){

            @Override
            public void run() {
                try {
                    PlayerToLocationRequest.this.teleport();
                }
                catch (Exception ignored) {
                    Request.REQUEST_QUEUE.remove(PlayerToLocationRequest.this.requestPlayer);
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskLaterAsynchronously(timer, delay / 50L);
    }

    protected void isMove(@NotNull Location lastLocation) {
        if (this.requestPlayer.getLocation().getX() != lastLocation.getX() || this.requestPlayer.getLocation().getY() != lastLocation.getY() || this.requestPlayer.getLocation().getZ() != lastLocation.getZ()) {
            REQUEST_QUEUE.remove(this.requestPlayer);
            this.timer.cancel();
            this.checkMoveTimer.cancel();
            this.countdownMessageTimer.cancel();
            if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                LanguageConfig language = LanguageConfig.getLanguage((CommandSender)this.requestPlayer);
                String title = language.getFormatMessage("teleport.canceled.self", new String[0]);
                if (LoadingConfigUtil.getConfig().isEnableSound()) {
                    PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                }
                this.requestPlayer.sendTitle(title, "");
            }
            SendMessageUtil.move(this.requestPlayer, this.requestPlayer);
        }
    }

    protected void setCheckMoveTimer(final @NotNull Location lastLocation) {
        HandyRunnable checkMoveTimer;
        this.checkMoveTimer = checkMoveTimer = new HandyRunnable(){
            long sec;
            {
                this.sec = PlayerToLocationRequest.this.delay * 20L;
            }

            @Override
            public void run() {
                try {
                    PlayerToLocationRequest.this.isMove(lastLocation);
                    if (--this.sec < 0L) {
                        this.cancel();
                    }
                }
                catch (Exception ignored) {
                    this.cancel();
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(checkMoveTimer, 0L, 1L);
    }

    protected void teleport() {
        if (LoadingConfigUtil.getConfig().isEnableTeleportDelay((CommandSender)this.requestPlayer)) {
            REQUEST_QUEUE.remove(this.requestPlayer);
            this.checkMoveTimer.cancel();
        }
        this.checkError();
        switch (this.commandType) {
            case WARP: {
                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                    SendMessageUtil.titleCountdownOverMessage(this.requestPlayer, this.targetName);
                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                        PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                }
                SendMessageUtil.tpToWarpMessage(this.requestPlayer, this.targetName);
                if (LoadingConfigUtil.getConfig().isNonTpaOrTphereDisableCheck() || !LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) break;
                this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
                break;
            }
            case HOME: {
                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                    SendMessageUtil.titleCountdownOverMessage(this.requestPlayer, this.targetName);
                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                        PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                }
                SendMessageUtil.tpToHomeMessage(this.requestPlayer, this.targetName);
                if (LoadingConfigUtil.getConfig().isNonTpaOrTphereDisableCheck() || !LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) break;
                this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
                break;
            }
            case SPAWN: {
                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                    Bukkit.getConsoleSender().sendMessage(this.targetName);
                    SendMessageUtil.titleCountdownOverMessage(this.requestPlayer, this.targetName);
                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                        PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                }
                SendMessageUtil.backSpawnSuccessMessage(this.requestPlayer);
                if (LoadingConfigUtil.getConfig().isNonTpaOrTphereDisableCheck() || !LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) break;
                this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
                break;
            }
            case BACK: {
                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                    SendMessageUtil.titleCountdownOverMessage(this.requestPlayer, this.targetName);
                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                        PlayerSchedulerUtil.playSound(this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    }
                }
                SendMessageUtil.backLastLocationSuccessMessage(this.requestPlayer);
                if (LoadingConfigUtil.getConfig().isNonTpaOrTphereDisableCheck() || !LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) break;
                this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
                break;
            }
            case RTP: {
                HandyRunnable rtpTimer = new HandyRunnable(){
                    long sec = 200L;

                    @Override
                    public void run() {
                        try {
                            if (!Objects.isNull(PlayerToLocationRequest.this.location)) {
                                Request.teleport(PlayerToLocationRequest.this.requestPlayer, PlayerToLocationRequest.this.location);
                                if (LoadingConfigUtil.getConfig().isEnableTitleMessage()) {
                                    SendMessageUtil.titleCountdownOverMessage(PlayerToLocationRequest.this.requestPlayer, PlayerToLocationRequest.this.targetName);
                                    if (LoadingConfigUtil.getConfig().isEnableSound()) {
                                        PlayerSchedulerUtil.playSound(PlayerToLocationRequest.this.requestPlayer, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                                    }
                                }
                                SendMessageUtil.rtpSuccessMessage(PlayerToLocationRequest.this.requestPlayer);
                                this.cancel();
                            }
                            if (--this.sec < 0L) {
                                throw new RtpFailedException((CommandSender)PlayerToLocationRequest.this.requestPlayer);
                            }
                        }
                        catch (Exception ignored) {
                            this.cancel();
                        }
                    }
                };
                HandySchedulerUtil.runTaskTimerAsynchronously(rtpTimer, 0L, 1L);
                if (!LoadingConfigUtil.getConfig().isNonTpaOrTphereDisableCheck() && LoadingConfigUtil.getConfig().isEnableCommandDelay((CommandSender)this.requestPlayer)) {
                    this.setCommandTimer(this.requestPlayer, LoadingConfigUtil.getConfig().getCommandDelay((CommandSender)this.requestPlayer));
                }
                return;
            }
        }
        PlayerToLocationRequest.teleport(this.requestPlayer, this.location);
    }

    @Override
    public void tpaccept() {
        throw new ErrorNoPendingRequestException((CommandSender)this.requestPlayer);
    }

    @Override
    public void tpdeny() {
        throw new ErrorNoPendingRequestException((CommandSender)this.requestPlayer);
    }
}

